/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block.tooltip;

import com.khazoda.plushables.block.tooltip.TooltipData;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.Nullable;

public class TooltipDataBuilder {
    private String number = TooltipData.DEFAULT.number();
    private String artist = TooltipData.DEFAULT.artist();
    private long creationTimestamp = TooltipData.DEFAULT.creationTimestamp();
    private String originalDate = null;
    private String trivia = TooltipData.DEFAULT.trivia();

    public static TooltipDataBuilder create() {
        return new TooltipDataBuilder();
    }

    public TooltipDataBuilder number(int number) {
        this.number = "#" + number;
        return this;
    }

    public TooltipDataBuilder artist(String artist) {
        this.artist = artist;
        return this;
    }

    public TooltipDataBuilder creationDate(String creationDate) {
        this.originalDate = creationDate;
        DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("d['st']['nd']['rd']['th'] MMMM yyyy"), DateTimeFormatter.ofPattern("d MMMM yyyy"), DateTimeFormatter.ofPattern("dd/MM/yyyy"), DateTimeFormatter.ofPattern("yyyy-MM-dd")};
        LocalDate parsedDate = null;
        for (DateTimeFormatter formatter : formatters) {
            try {
                parsedDate = LocalDate.parse(creationDate, formatter);
                break;
            }
            catch (Exception exception) {
            }
        }
        this.creationTimestamp = parsedDate != null ? parsedDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli() : 0L;
        return this;
    }

    public TooltipDataBuilder trivia(@Nullable String trivia) {
        this.trivia = trivia;
        return this;
    }

    public TooltipData build() {
        return new TooltipData(this.number, this.artist, this.creationTimestamp, this.originalDate, this.trivia);
    }
}

