/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.block.tooltip;

import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public record TooltipData(String number, String artist, long creationTimestamp, @Nullable String originalDate, @Nullable String trivia) {
    public static final TooltipData DEFAULT = new TooltipData("#0", "Khazoda", 946684800000L, null, null);

    public String localizeDate(String rawLocale) {
        if (this.creationTimestamp == 0L && this.originalDate != null) {
            return this.originalDate;
        }
        try {
            Locale locale = Locale.forLanguageTag(rawLocale.replace('_', '-'));
            Instant instant = Instant.ofEpochMilli(this.creationTimestamp);
            Chronology chronology = Chronology.ofLocale(locale);
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.LONG, null).toFormatter(locale).withChronology(chronology).withZone(ZoneId.systemDefault());
            return formatter.format(instant);
        }
        catch (Exception e) {
            return this.originalDate != null ? this.originalDate : "Unknown Date";
        }
    }
}

