/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.plushables.item;

import com.khazoda.plushables.block.BasePlushable;
import com.khazoda.plushables.platform.Services;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;

public class PlushableBlockItem
extends BlockItem {
    public PlushableBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        if (!Services.PLATFORM.isClientSide()) {
            return;
        }
        Block block = this.getBlock();
        if (!(block instanceof BasePlushable)) {
            return;
        }
        BasePlushable basePlushable = (BasePlushable)block;
        if (!Minecraft.getInstance().hasControlDown()) {
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.plushables.holdctrl").withStyle(ChatFormatting.GRAY));
            return;
        }
        tooltipAdder.accept((Component)Component.literal((String)basePlushable.getTooltipData().number()).withStyle(ChatFormatting.YELLOW));
        tooltipAdder.accept((Component)Component.translatable((String)"tooltip.plushables.artist").append(" \u00b7 " + basePlushable.getTooltipData().artist()).withStyle(ChatFormatting.GREEN));
        tooltipAdder.accept((Component)Component.translatable((String)"tooltip.plushables.created").append(" \u00b7 " + basePlushable.getTooltipData().localizeDate(Minecraft.getInstance().getLanguageManager().getSelected())).withStyle(ChatFormatting.DARK_GREEN));
        if (basePlushable.getTooltipData().trivia() != null) {
            tooltipAdder.accept(CommonComponents.EMPTY);
            this.addTrivia(tooltipAdder, basePlushable.getTooltipData().trivia());
        }
    }

    private void addTrivia(Consumer<Component> tooltipAdder, String trivia) {
        String[] words = trivia.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() > 35) {
                tooltipAdder.accept((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GRAY));
                currentLine.setLength(0);
            }
            currentLine.append(word).append(" ");
        }
        if (!currentLine.isEmpty()) {
            tooltipAdder.accept((Component)Component.literal((String)currentLine.toString().trim()).withStyle(ChatFormatting.GRAY));
        }
    }
}

