/*
 * Decompiled with CFR 0.152.
 */
package net.ap.action;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ap.action.QuickActionHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class QuickActionFileManager {
    private static final Gson gson = new Gson();
    private static File quickActionsFolder;
    private static File quickActionsFile;
    private static File optionsFile;

    public static Map<String, HashMap<String, List<String>>> load() throws IOException {
        if (optionsFile.exists()) {
            FileReader optionsReader = new FileReader(optionsFile);
            Type optionsType = new TypeToken<HashMap<String, String>>(){}.getType();
            HashMap options = (HashMap)gson.fromJson((Reader)optionsReader, optionsType);
            QuickActionHandler.actionSet = options != null ? options.getOrDefault("equipped", "") : "";
            optionsReader.close();
        }
        if (!quickActionsFile.exists()) {
            return new HashMap<String, HashMap<String, List<String>>>();
        }
        Type type = new TypeToken<Map<String, HashMap<String, List<String>>>>(){}.getType();
        FileReader fileReader = new FileReader(quickActionsFile);
        Map data = (Map)gson.fromJson((Reader)fileReader, type);
        fileReader.close();
        if (data == null) {
            return new HashMap<String, HashMap<String, List<String>>>();
        }
        return data;
    }

    public static void save(Map<String, HashMap<String, List<String>>> quickActions) throws IOException {
        HashMap data = new HashMap();
        FileWriter fileWriter = new FileWriter(quickActionsFile);
        gson.toJson(quickActions, (Appendable)fileWriter);
        fileWriter.close();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("equipped", QuickActionHandler.actionSet);
        FileWriter optionsWriter = new FileWriter(optionsFile);
        gson.toJson(options, (Appendable)optionsWriter);
        optionsWriter.close();
    }

    public static void initialize() {
        quickActionsFolder = new File(FabricLoader.getInstance().getGameDir().toFile(), "quick_actions");
        quickActionsFile = new File(quickActionsFolder, "quick_actions.json");
        optionsFile = new File(quickActionsFolder, "options.json");
        if (!quickActionsFolder.exists()) {
            quickActionsFolder.mkdirs();
        }
    }
}

