/*
 * Decompiled with CFR 0.152.
 */
package net.ap.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ap.action.QuickActionFileManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class QuickActionHandler {
    private static Map<String, HashMap<String, List<String>>> QUICK_ACTIONS = new HashMap<String, HashMap<String, List<String>>>();
    public static String actionSet = "";

    public static HashMap<String, List<String>> getTriggers(String set) {
        return QUICK_ACTIONS.get(set);
    }

    public static boolean containsSet(String set) {
        return QUICK_ACTIONS.containsKey(set);
    }

    public static boolean containsTrigger(String set, String trigger) {
        if (!QUICK_ACTIONS.containsKey(set)) {
            return false;
        }
        return QUICK_ACTIONS.get(set).containsKey(trigger);
    }

    public static boolean containsAction(String set, String trigger, String action) {
        if (!QUICK_ACTIONS.containsKey(set)) {
            return false;
        }
        if (!QUICK_ACTIONS.get(set).containsKey(trigger)) {
            return false;
        }
        return QUICK_ACTIONS.get(set).get(trigger).contains(action);
    }

    public static List<String> getActions(String set, String trigger) {
        if (!QUICK_ACTIONS.containsKey(set)) {
            return new ArrayList<String>();
        }
        if (!QUICK_ACTIONS.get(set).containsKey(trigger)) {
            return new ArrayList<String>();
        }
        return QUICK_ACTIONS.get(set).get(trigger);
    }

    public static Map<String, HashMap<String, List<String>>> copyQuickActions() {
        return Map.copyOf(QUICK_ACTIONS);
    }

    public static void addAction(String set, String trigger, String command) {
        if (!QUICK_ACTIONS.containsKey(set)) {
            QUICK_ACTIONS.put(set, new HashMap());
        }
        if (!QUICK_ACTIONS.get(set).containsKey(trigger)) {
            QUICK_ACTIONS.get(set).put(trigger, new ArrayList<String>(List.of(command)));
        } else {
            QUICK_ACTIONS.get(set).get(trigger).add(command);
        }
        try {
            QuickActionHandler.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeSet(String set) {
        QUICK_ACTIONS.remove(set);
        try {
            QuickActionHandler.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeTrigger(String set, String trigger) {
        QUICK_ACTIONS.get(set).remove(trigger);
        try {
            QuickActionHandler.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeAction(String set, String trigger, String action) {
        QUICK_ACTIONS.get(set).get(trigger).remove(action);
        try {
            QuickActionHandler.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setActionSet(String set) {
        actionSet = set;
        try {
            QuickActionHandler.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save() throws IOException {
        QuickActionFileManager.save(QUICK_ACTIONS);
    }

    public static void load() throws IOException {
        QUICK_ACTIONS = QuickActionFileManager.load();
    }
}

