/*
 * Decompiled with CFR 0.152.
 */
package net.ap.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import net.ap.action.QuickActionHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class QuickActionCommand {
    public QuickActionCommand(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"quick_action").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"set", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("general");
            for (String set : QuickActionHandler.copyQuickActions().keySet()) {
                builder.suggest(set);
            }
            return builder.buildFuture();
        }).then(ClientCommandManager.argument((String)"trigger", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            String trigger = StringArgumentType.getString((CommandContext)c, (String)"trigger");
            String command = StringArgumentType.getString((CommandContext)c, (String)"command");
            QuickActionHandler.addAction(set, trigger, command);
            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Bound command \"%s\" to trigger \"%s\" in set \"%s\"".formatted(command, trigger, set)));
            return 1;
        })))))).then(ClientCommandManager.literal((String)"remove").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"set", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String set : QuickActionHandler.copyQuickActions().keySet()) {
                builder.suggest(set);
            }
            return builder.buildFuture();
        }).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            if (QuickActionHandler.containsSet(set)) {
                QuickActionHandler.removeSet(set);
                ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removed all commands from set \"%s\"".formatted(set)));
            } else {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" not found".formatted(set)));
            }
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"trigger", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            String trigger = StringArgumentType.getString((CommandContext)c, (String)"trigger");
            if (!QuickActionHandler.containsSet(set)) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" not found".formatted(set)));
                return 1;
            }
            if (QuickActionHandler.containsTrigger(set, trigger)) {
                QuickActionHandler.removeTrigger(set, trigger);
                ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removed all commands from trigger \"%s\" from set \"%s\"".formatted(trigger, set)));
            } else {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Trigger \"%s\" not found".formatted(trigger)));
            }
            return 1;
        })).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            String trigger = StringArgumentType.getString((CommandContext)c, (String)"trigger");
            String command = StringArgumentType.getString((CommandContext)c, (String)"command");
            if (QuickActionHandler.containsSet(set)) {
                if (!QuickActionHandler.containsTrigger(set, trigger)) {
                    ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Trigger \"%s\" not found in set \"%s\"".formatted(trigger, set)));
                    return 1;
                }
                if (QuickActionHandler.containsAction(set, trigger, command)) {
                    QuickActionHandler.removeAction(set, trigger, command);
                    ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Removed command \"%s\" from trigger \"%s\" from set \"%s\"".formatted(command, trigger, set)));
                } else {
                    ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Command \"%s\" not found in trigger \"%s\" in set \"%s\"".formatted(command, trigger, set)));
                }
            } else {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" not found".formatted(set)));
            }
            return 1;
        })))))).then(ClientCommandManager.literal((String)"equip").then(ClientCommandManager.argument((String)"set", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String set : QuickActionHandler.copyQuickActions().keySet()) {
                builder.suggest(set);
            }
            return builder.buildFuture();
        }).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            if (set.equals("general")) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Cannot equip general as it is always equipped"));
            } else if (!QuickActionHandler.containsSet(set)) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" does not exist".formatted(set)));
            } else {
                QuickActionHandler.setActionSet(set);
                ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Equipped set \"%s\"".formatted(set)));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"set", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String set : QuickActionHandler.copyQuickActions().keySet()) {
                builder.suggest(set);
            }
            return builder.buildFuture();
        }).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            if (!QuickActionHandler.containsSet(set)) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" not found".formatted(set)));
                return 1;
            }
            ((FabricClientCommandSource)c.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"---- Triggers in set: \"%s\" ----".formatted(set)).method_54663(-11010079), false);
            for (Map.Entry<String, List<String>> entry : QuickActionHandler.getTriggers(set).entrySet()) {
                ((FabricClientCommandSource)c.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("- \"" + entry.getKey() + "\"")), false);
            }
            return 1;
        })).then(ClientCommandManager.argument((String)"trigger", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String set = StringArgumentType.getString((CommandContext)c, (String)"set");
            String trigger = StringArgumentType.getString((CommandContext)c, (String)"trigger");
            if (!QuickActionHandler.containsSet(set)) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Set \"%s\" not found".formatted(set)));
                return 1;
            }
            if (!QuickActionHandler.containsTrigger(set, trigger)) {
                ((FabricClientCommandSource)c.getSource()).sendError((class_2561)class_2561.method_43470((String)"Trigger \"%s\" not found in set \"%s\"".formatted(trigger, set)));
                return 1;
            }
            ((FabricClientCommandSource)c.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"---- Commands in trigger: \"%s\" | in set: \"%s\" ----".formatted(trigger, set)).method_54663(-11010079), false);
            for (String action : QuickActionHandler.getActions(set, trigger)) {
                ((FabricClientCommandSource)c.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)("- \"" + action + "\"")), false);
            }
            return 1;
        })))));
    }
}

