/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords;

import com.celestialswords.abilities.AbilityManager;
import com.celestialswords.commands.RecipeCommand;
import com.celestialswords.commands.ReloadCommand;
import com.celestialswords.commands.TabCompleter;
import com.celestialswords.commands.UpdateCommand;
import com.celestialswords.config.ConfigManager;
import com.celestialswords.dependency.DependencyManager;
import com.celestialswords.listeners.AbilityListener;
import com.celestialswords.listeners.ContainerProtectionListener;
import com.celestialswords.listeners.CraftingListener;
import com.celestialswords.listeners.FallDamageListener;
import com.celestialswords.listeners.GUIListener;
import com.celestialswords.listeners.HopperProtectionListener;
import com.celestialswords.listeners.InventoryMoveListener;
import com.celestialswords.listeners.ItemFrameProtectionListener;
import com.celestialswords.listeners.MaceEffectListener;
import com.celestialswords.listeners.PlayerCleanupListener;
import com.celestialswords.listeners.SwordEffectsListener;
import com.celestialswords.listeners.SwordLifecycleListener;
import com.celestialswords.listeners.SwordSelectionListener;
import com.celestialswords.listeners.TriggerListener;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.models.SwordEnchantments;
import com.celestialswords.tracking.SwordTracker;
import com.celestialswords.utils.TriggerManager;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CelestialSwords
extends JavaPlugin {
    private AbilityManager abilityManager;
    private SwordTracker swordTracker;
    private ConfigManager configManager;
    private DependencyManager dependencyManager;
    private SwordEffectsListener swordEffectsListener;

    public void onEnable() {
        this.dependencyManager = new DependencyManager(this);
        this.setupDependencies();
        UpdateCommand.setPlugin(this);
        UpdateCommand.checkForUpdatesInBackground();
        this.configManager = new ConfigManager(this);
        CelestialSword.setConfigManager(this.configManager);
        SwordEnchantments.setConfigManager(this.configManager);
        this.swordTracker = new SwordTracker(this);
        this.abilityManager = new AbilityManager((Plugin)this);
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("AstralSwords plugin has been enabled!");
    }

    private void registerCommands() {
        ReloadCommand.setPlugin(this);
        ReloadCommand.setConfigManager(this.configManager);
        RecipeCommand recipeCommand = new RecipeCommand(this.swordTracker, this.abilityManager);
        this.getCommand("aswords").setExecutor((CommandExecutor)recipeCommand);
        this.getCommand("aswords").setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this.swordTracker), (Plugin)this);
        this.swordEffectsListener = new SwordEffectsListener((Plugin)this, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.swordEffectsListener, (Plugin)this);
        this.abilityManager.setSwordEffectsListener(this.swordEffectsListener);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(this.swordTracker, (Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AbilityListener(this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FallDamageListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SwordLifecycleListener(this.swordTracker, (Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryMoveListener(this.swordTracker), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ContainerProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HopperProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemFrameProtectionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MaceEffectListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TriggerListener((Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SwordSelectionListener((Plugin)this, this.swordTracker), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCleanupListener(this.abilityManager, this.swordEffectsListener), (Plugin)this);
    }

    private void setupDependencies() {
        this.dependencyManager.registerDependency("FaithBreak", "Jghhg4Vq", "latest", "");
        this.dependencyManager.registerDependency("", "", "", "");
        this.dependencyManager.checkAndInstallDependencies();
    }

    public File getPluginFile() {
        return this.getFile();
    }

    public void onDisable() {
        if (this.swordTracker != null) {
            this.swordTracker.cleanup();
        }
        if (this.configManager != null) {
            this.configManager.saveConfigurations();
        }
        TriggerManager.clearListeningPlayers();
        this.getLogger().info("AstralSwords plugin has been disabled!");
    }
}

