/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ModrinthUpdater {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/";
    private static final String USER_AGENT = "CelestialSwords/ModrinthUpdater";
    private final Plugin plugin;
    private final String projectId;
    private final File pluginFile;
    private final boolean announce;
    private String currentVersion;
    private String latestVersion;
    private String downloadUrl;
    private String versionName;
    private UpdateResult result = UpdateResult.NO_UPDATE;
    private final UpdateCallback callback;

    public ModrinthUpdater(Plugin plugin, String projectId, File pluginFile, boolean announce, UpdateCallback callback) {
        this.plugin = plugin;
        this.projectId = projectId;
        this.pluginFile = pluginFile;
        this.announce = announce;
        this.callback = callback;
        this.currentVersion = plugin.getDescription().getVersion();
        new Thread(this::runUpdateCheck).start();
    }

    public ModrinthUpdater(Plugin plugin, String projectId, File pluginFile, boolean announce) {
        this(plugin, projectId, pluginFile, announce, null);
    }

    private void runUpdateCheck() {
        if (this.checkForUpdates() && this.result == UpdateResult.UPDATE_AVAILABLE && this.announce) {
            this.plugin.getLogger().info("A new version of CelestialSwords is available: " + this.latestVersion);
            this.plugin.getLogger().info("Use '/cswords update' to download the update.");
        }
        if (this.callback != null) {
            new BukkitRunnable(){

                public void run() {
                    ModrinthUpdater.this.callback.onFinish(ModrinthUpdater.this);
                }
            }.runTask(this.plugin);
        }
    }

    public boolean checkForUpdates() {
        try {
            String line;
            URL url = new URL(MODRINTH_API_URL + this.projectId + "/version");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (connection.getResponseCode() != 200) {
                this.plugin.getLogger().warning("Failed to check for updates: HTTP " + connection.getResponseCode());
                this.result = UpdateResult.FAIL_API;
                return false;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            JSONArray versions = (JSONArray)JSONValue.parse((String)response.toString());
            if (versions.isEmpty()) {
                this.plugin.getLogger().warning("No versions found for project ID: " + this.projectId);
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
            JSONObject latestVersion = (JSONObject)versions.get(0);
            this.latestVersion = (String)latestVersion.get((Object)"version_number");
            this.versionName = (String)latestVersion.get((Object)"name");
            JSONArray files = (JSONArray)latestVersion.get((Object)"files");
            if (files.isEmpty()) {
                this.plugin.getLogger().warning("No download files found for the latest version");
                this.result = UpdateResult.FAIL_DOWNLOAD;
                return false;
            }
            JSONObject primaryFile = (JSONObject)files.get(0);
            this.downloadUrl = (String)primaryFile.get((Object)"url");
            if (this.shouldUpdate(this.currentVersion, this.latestVersion)) {
                this.result = UpdateResult.UPDATE_AVAILABLE;
                return true;
            }
            this.result = UpdateResult.NO_UPDATE;
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error checking for updates", e);
            this.result = UpdateResult.FAIL_API;
            return false;
        }
    }

    public boolean downloadUpdate() {
        if (this.downloadUrl == null) {
            return false;
        }
        try {
            int bytesRead;
            File updateFolder = this.plugin.getServer().getUpdateFolderFile();
            if (!updateFolder.exists()) {
                updateFolder.mkdirs();
            }
            String newFileName = "CelestialSwords-" + this.latestVersion + ".jar";
            File outputFile = new File(updateFolder, newFileName);
            URL url = new URL(this.downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", USER_AGENT);
            if (connection.getResponseCode() != 200) {
                this.plugin.getLogger().warning("Failed to download update: HTTP " + connection.getResponseCode());
                this.result = UpdateResult.FAIL_DOWNLOAD;
                return false;
            }
            int fileSize = connection.getContentLength();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            FileOutputStream out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[1024];
            int totalBytesRead = 0;
            if (this.announce) {
                this.plugin.getLogger().info("Downloading update: " + this.versionName);
            }
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                if (fileSize <= 0 || !this.announce || (totalBytesRead += bytesRead) % (fileSize / 10) >= 1024) continue;
                int percent = totalBytesRead * 100 / fileSize;
                this.plugin.getLogger().info("Download progress: " + percent + "%");
            }
            in.close();
            out.close();
            if (this.announce) {
                this.plugin.getLogger().info("Download complete! The update will be installed when the server restarts.");
            }
            this.result = UpdateResult.SUCCESS;
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error downloading update", e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
            return false;
        }
    }

    public void sendUpdateNotification(Player player) {
        if (this.result != UpdateResult.UPDATE_AVAILABLE && this.result != UpdateResult.SUCCESS) {
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=========================================");
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "A new version of CelestialSwords is available!");
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "Current version: " + String.valueOf(ChatColor.RED) + this.currentVersion);
        player.sendMessage(String.valueOf(ChatColor.WHITE) + "Latest version: " + String.valueOf(ChatColor.GREEN) + this.latestVersion);
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " [{\"text\":\"[Click here to update]\",\"color\":\"green\",\"bold\":true,\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/cswords update\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"Click to update to version " + this.latestVersion + "\"}}]"));
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=========================================");
    }

    public void broadcastUpdateNotification(String permission) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            this.sendUpdateNotification(player);
        }
    }

    private boolean shouldUpdate(String currentVersion, String latestVersion) {
        return !currentVersion.equals(latestVersion);
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        DISABLED,
        FAIL_DOWNLOAD,
        FAIL_API,
        FAIL_NOVERSION,
        FAIL_BADID,
        UPDATE_AVAILABLE;

    }

    public static interface UpdateCallback {
        public void onFinish(ModrinthUpdater var1);
    }
}

