/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.DragonWrathAbility;
import com.celestialswords.abilities.EclipseBlade;
import com.celestialswords.abilities.PhoenixTalonAbility;
import com.celestialswords.abilities.PowerHouseAbility;
import com.celestialswords.abilities.ShadowbaneAbility;
import com.celestialswords.abilities.SkyfallAbility;
import com.celestialswords.abilities.SoulReaverAbility;
import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.abilities.ThunderstrikeAbility;
import com.celestialswords.abilities.VenomEdgeAbility;
import com.celestialswords.abilities.WardenOathAbility;
import com.celestialswords.abilities.WindbladeAbility;
import com.celestialswords.listeners.SwordEffectsListener;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.utils.ParticleEffectManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AbilityManager {
    private final Map<CelestialSword, SwordAbility> abilities = new HashMap<CelestialSword, SwordAbility>();
    private final ParticleEffectManager particleEffectManager;
    private final Plugin plugin;

    public AbilityManager(Plugin plugin) {
        this.plugin = plugin;
        this.particleEffectManager = new ParticleEffectManager(plugin);
        this.abilities.put(CelestialSword.SKYFALL_BLADE, new SkyfallAbility(plugin));
        this.abilities.put(CelestialSword.THUNDERSTRIKE, new ThunderstrikeAbility(plugin));
        this.abilities.put(CelestialSword.DRAGONS_WRATH, new DragonWrathAbility(plugin));
        this.abilities.put(CelestialSword.PHOENIX_TALON, new PhoenixTalonAbility(plugin));
        this.abilities.put(CelestialSword.WARDENS_OATH, new WardenOathAbility(plugin));
        this.abilities.put(CelestialSword.SOUL_REAVER, new SoulReaverAbility(plugin));
        this.abilities.put(CelestialSword.ECLIPSE_BLADE, new EclipseBlade(plugin));
        this.abilities.put(CelestialSword.SHADOWBANE, new ShadowbaneAbility(plugin));
        this.abilities.put(CelestialSword.VENOM_EDGE, new VenomEdgeAbility(plugin));
        this.abilities.put(CelestialSword.WINDBLADE, new WindbladeAbility(plugin));
        this.abilities.put(CelestialSword.POWER_HOUSE, new PowerHouseAbility(plugin));
    }

    public boolean activateAbility(Player player, CelestialSword sword) {
        SwordAbility ability = this.abilities.get((Object)sword);
        if (ability != null) {
            if (ability.isOnCooldown(player)) {
                return false;
            }
            ability.activate(player);
            return true;
        }
        return false;
    }

    public SwordAbility getAbility(CelestialSword sword) {
        return this.abilities.get((Object)sword);
    }

    public ParticleEffectManager getParticleEffectManager() {
        return this.particleEffectManager;
    }

    public void playActivationEffect(Player player, CelestialSword sword) {
        this.particleEffectManager.playSwordActivationEffect(player, sword);
    }

    public void setSwordEffectsListener(SwordEffectsListener swordEffectsListener) {
        EclipseBlade eclipseBlade = (EclipseBlade)this.abilities.get((Object)CelestialSword.ECLIPSE_BLADE);
        if (eclipseBlade != null) {
            eclipseBlade.setSwordEffectsListener(swordEffectsListener);
        }
    }
}

