/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class DragonWrathAbility
implements SwordAbility {
    private static final long COOLDOWN = 20000L;
    private static final float DRAGON_BREATH_RADIUS = 4.0f;
    private static final int DRAGON_BREATH_DURATION = 200;
    private static final double DAMAGE_PER_TICK = 2.0;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;

    public DragonWrathAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 20000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Dragon's Wrath", this.cooldowns.get(player.getUniqueId()) + 20000L);
            return;
        }
        this.createDragonBreathEffect(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Dragon's Wrath", this.cooldowns.get(player.getUniqueId()) + 20000L);
        }
    }

    private void createDragonBreathEffect(final Player player) {
        Location location = player.getTargetBlock(null, 10).getLocation().add(0.0, 1.0, 0.0);
        player.getWorld().spawnParticle(Particle.DRAGON_BREATH, location, 100, 1.0, 1.0, 1.0, 0.1);
        player.getWorld().playSound(location, Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        final AreaEffectCloud cloud = (AreaEffectCloud)player.getWorld().spawnEntity(location, EntityType.AREA_EFFECT_CLOUD);
        cloud.setRadius(4.0f);
        cloud.setDuration(200);
        cloud.setParticle(Particle.DRAGON_BREATH);
        cloud.setSource((ProjectileSource)player);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks++ >= 200 || cloud.isDead()) {
                    this.cancel();
                    return;
                }
                for (Entity entity : cloud.getNearbyEntities(4.0, 4.0, 4.0)) {
                    Player targetPlayer;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity;
                    if (entity == player || target instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)target)) continue;
                    target.damage(2.0, (Entity)player);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 60, 1));
                }
            }
        }.runTaskTimer(this.plugin, 0L, 20L);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 20000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

