/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.listeners.SwordEffectsListener;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import com.celestialswords.utils.ParticleEffectManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EclipseBlade
implements SwordAbility {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> visibilityActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> invisibilityTaskIds = new HashMap<UUID, Integer>();
    private final Plugin plugin;
    private final ParticleEffectManager particleEffectManager;
    private SwordEffectsListener swordEffectsListener;
    private static final int BLINDNESS_DURATION = 60;
    private static final int INVISIBILITY_DURATION = 1800;
    private static final double BLINDNESS_RADIUS = 6.0;
    private static final int COOLDOWN_TIME = 20000;
    private static final float SOUND_VOLUME = 0.5f;
    private static final float SOUND_PITCH = 1.2f;

    public EclipseBlade(Plugin plugin) {
        this.plugin = plugin;
        this.particleEffectManager = new ParticleEffectManager(plugin);
    }

    public void setSwordEffectsListener(SwordEffectsListener swordEffectsListener) {
        this.swordEffectsListener = swordEffectsListener;
    }

    @Override
    public void activate(final Player player) {
        if (this.visibilityActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            ActionBarManager.sendMessage(player, "\u00a75Eclipse Blade: \u00a7cAbility is already active!");
            return;
        }
        Integer existingTaskId = this.invisibilityTaskIds.remove(player.getUniqueId());
        if (existingTaskId != null) {
            this.plugin.getServer().getScheduler().cancelTask(existingTaskId.intValue());
        }
        Location playerLocation = player.getLocation();
        for (LivingEntity entity : playerLocation.getWorld().getLivingEntities()) {
            double distance;
            Player targetPlayer;
            if (!(entity instanceof Player) || (targetPlayer = (Player)entity).equals((Object)player) || !((distance = entity.getLocation().distance(playerLocation)) <= 6.0) || TrustManager.isTrusted(player, targetPlayer)) continue;
            targetPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 1800, 0, false, false, true));
        this.visibilityActive.put(player.getUniqueId(), true);
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.equals((Object)player)) continue;
            onlinePlayer.hidePlayer(this.plugin, player);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.5f, 1.2f);
        ActionBarManager.sendMessage(player, "\u00a75Eclipse Blade: \u00a7aBlindness applied to enemies \u00a7dInvisibility activated");
        this.particleEffectManager.playEclipseBladeEffect(player);
        int taskId = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, new Runnable(){
            final /* synthetic */ EclipseBlade this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.visibilityActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                    this.this$0.startCooldown(player);
                    ActionBarManager.startPersistentCooldown(this.this$0.plugin, player, "Eclipse Blade", this.this$0.cooldowns.get(player.getUniqueId()));
                    for (Player onlinePlayer : this.this$0.plugin.getServer().getOnlinePlayers()) {
                        if (onlinePlayer.equals((Object)player)) continue;
                        onlinePlayer.showPlayer(this.this$0.plugin, player);
                    }
                    this.this$0.visibilityActive.put(player.getUniqueId(), false);
                    if (this.this$0.swordEffectsListener != null) {
                        this.this$0.swordEffectsListener.cleanupEclipseBladeData(player);
                    }
                }
                this.this$0.invisibilityTaskIds.remove(player.getUniqueId());
            }
        }, 1800L).getTaskId();
        this.invisibilityTaskIds.put(player.getUniqueId(), taskId);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        boolean isActive = this.visibilityActive.getOrDefault(player.getUniqueId(), false);
        boolean onCooldown = this.cooldowns.containsKey(player.getUniqueId()) && this.cooldowns.get(player.getUniqueId()) > System.currentTimeMillis();
        return isActive || onCooldown;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + 20000L);
    }

    public void removeInvisibility(Player player) {
        Integer taskId = this.invisibilityTaskIds.remove(player.getUniqueId());
        if (taskId != null) {
            this.plugin.getServer().getScheduler().cancelTask(taskId.intValue());
        }
        if (this.visibilityActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.visibilityActive.put(player.getUniqueId(), false);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                if (onlinePlayer.equals((Object)player)) continue;
                onlinePlayer.showPlayer(this.plugin, player);
            }
            ActionBarManager.stopPersistentCooldown(player);
            ActionBarManager.sendMessage(player, "\u00a75Eclipse Blade: \u00a7cInvisibility removed manually");
        }
    }

    public Map<UUID, Boolean> getInvisibilityActive() {
        return this.visibilityActive;
    }

    public void onPlayerQuitOrDeath(Player player) {
        Integer taskId = this.invisibilityTaskIds.remove(player.getUniqueId());
        if (taskId != null) {
            this.plugin.getServer().getScheduler().cancelTask(taskId.intValue());
        }
        if (this.visibilityActive.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.visibilityActive.put(player.getUniqueId(), false);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                if (onlinePlayer.equals((Object)player)) continue;
                onlinePlayer.showPlayer(this.plugin, player);
            }
        }
        ActionBarManager.stopPersistentCooldown(player);
        this.cooldowns.remove(player.getUniqueId());
    }
}

