/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import com.celestialswords.utils.ParticleEffectManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PhoenixTalonAbility
implements SwordAbility,
Listener {
    private static final long COOLDOWN = 20000L;
    private static final float EXPLOSION_POWER = 3.45f;
    private static final double FIRE_DAMAGE = 8.0;
    private static final int FIRE_DURATION = 100;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;
    private final ParticleEffectManager particleEffectManager;

    public PhoenixTalonAbility(Plugin plugin) {
        this.plugin = plugin;
        this.particleEffectManager = new ParticleEffectManager(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 20000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Phoenix Talon", this.cooldowns.get(player.getUniqueId()) + 20000L);
            return;
        }
        this.particleEffectManager.playPhoenixTalonEffect(player);
        this.launchFireball(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Phoenix Talon", this.cooldowns.get(player.getUniqueId()) + 20000L);
        }
    }

    private void launchFireball(final Player player) {
        Location loc = player.getEyeLocation();
        Vector direction = loc.getDirection();
        final Fireball fireball = (Fireball)player.getWorld().spawn(loc, Fireball.class);
        fireball.setShooter((ProjectileSource)player);
        fireball.setYield(3.45f);
        fireball.setIsIncendiary(true);
        fireball.setVelocity(direction.multiply(2));
        player.getWorld().playSound(loc, Sound.ENTITY_BLAZE_SHOOT, 1.0f, 0.5f);
        player.getWorld().spawnParticle(Particle.FLAME, loc, 20, 0.5, 0.5, 0.5, 0.1);
        new BukkitRunnable(this){
            final /* synthetic */ PhoenixTalonAbility this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (fireball.isDead()) {
                    Location impactLoc = fireball.getLocation();
                    this.this$0.createExplosionEffect(impactLoc, player);
                    this.cancel();
                }
            }
        }.runTaskTimer(this.plugin, 1L, 1L);
    }

    private void createExplosionEffect(Location location, Player shooter) {
        location.getWorld().createExplosion(location, 3.45f, true, true, (Entity)shooter);
        location.getWorld().spawnParticle(Particle.EXPLOSION, location, 10, 1.0, 1.0, 1.0, 0.1);
        location.getWorld().spawnParticle(Particle.FLAME, location, 50, 2.0, 2.0, 2.0, 0.1);
        location.getWorld().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.5f);
        for (Entity entity : location.getWorld().getNearbyEntities(location, 5.0, 5.0, 5.0)) {
            Player targetPlayer;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity == shooter || target instanceof Player && TrustManager.isTrusted(shooter, targetPlayer = (Player)target)) continue;
            target.damage(8.0, (Entity)shooter);
            target.setFireTicks(100);
        }
    }

    private void applyFireResistance(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
        ActionBarManager.sendMessage(player, "\u00a76Phoenix Talon grants you fire resistance!");
    }

    public void removeFireResistance(Player player) {
        player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 20000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onExplosionDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem != null && heldItem.hasItemMeta() && heldItem.getItemMeta().hasDisplayName() && heldItem.getItemMeta().getDisplayName().substring(2).equals(CelestialSword.PHOENIX_TALON.getDisplayName())) {
            event.setCancelled(true);
            player.getWorld().spawnParticle(Particle.FLAME, player.getLocation(), 10, 0.5, 0.5, 0.5, 0.1);
            player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.5f, 1.0f);
        }
    }
}

