/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PowerHouseAbility
implements SwordAbility,
Listener {
    private static final long COOLDOWN = 30000L;
    private static final double DAMAGE = 6.0;
    private static final int LAUNCH_HEIGHT = 8;
    private static final int RADIUS = 15;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;

    public PowerHouseAbility(Plugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Ground Strike", this.cooldowns.get(player.getUniqueId()) + 30000L);
            return;
        }
        this.performGroundStrike(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Ground Strike", this.cooldowns.get(player.getUniqueId()) + 30000L);
        }
    }

    private void performGroundStrike(Player player) {
        Location location = player.getLocation();
        player.getWorld().playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.5f);
        player.getWorld().playSound(location, Sound.BLOCK_GRAVEL_BREAK, 1.0f, 0.2f);
        this.createShockwaveEffect(location);
        for (Entity entity : player.getWorld().getNearbyEntities(location, 15.0, 15.0, 15.0)) {
            Player targetPlayer;
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || entity == player || (target = (LivingEntity)entity) instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)target)) continue;
            Vector direction = target.getLocation().toVector().subtract(location.toVector()).normalize();
            direction.setY(1.2);
            target.setVelocity(direction.multiply(4.0));
            target.damage(6.0, (Entity)player);
        }
        ActionBarManager.sendMessage(player, "\u00a76Ground Strike \u00a7aactivated!");
    }

    private void createShockwaveEffect(Location center) {
        for (double radius = 0.5; radius <= 15.0; radius += 0.5) {
            double currentRadius = radius;
            this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
                for (double angle = 0.0; angle < Math.PI * 2; angle += 0.19634954084936207) {
                    double x = center.getX() + currentRadius * Math.cos(angle);
                    double z = center.getZ() + currentRadius * Math.sin(angle);
                    for (double y = 0.0; y <= 2.0; y += 1.0) {
                        Location particleLoc = new Location(center.getWorld(), x, center.getY() + y, z);
                        center.getWorld().spawnParticle(Particle.EXPLOSION, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                        center.getWorld().spawnParticle(Particle.FLAME, particleLoc, 3, 0.2, 0.1, 0.2, 0.0);
                    }
                }
            }, (long)(radius * 2.0));
        }
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 30000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

