/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ShadowbaneAbility
implements SwordAbility {
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TIME = 20000L;
    private final Plugin plugin;

    public ShadowbaneAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 20000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Shadowbane", this.cooldowns.get(player.getUniqueId()) + 20000L);
            return;
        }
        Location playerLoc = player.getLocation();
        player.getWorld().playSound(playerLoc, Sound.ENTITY_WITHER_HURT, 1.0f, 1.0f);
        for (Entity entity : player.getNearbyEntities(5.0, 5.0, 5.0)) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            LivingEntity target = (LivingEntity)entity;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                if (TrustManager.isTrusted(player, targetPlayer)) continue;
                this.applyEffects(target);
                continue;
            }
            this.applyEffects(target);
        }
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Shadowbane", this.cooldowns.get(player.getUniqueId()) + 20000L);
        }
        ActionBarManager.sendMessage(player, "\u00a75Shadowbane's darkness weakens nearby foes!");
    }

    private void applyEffects(LivingEntity target) {
        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 300, 0));
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUsed = this.cooldowns.get(player.getUniqueId());
        return lastUsed != null && System.currentTimeMillis() - lastUsed < 20000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

