/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SkyfallAbility
implements SwordAbility {
    private static final long COOLDOWN = 30000L;
    private static final double LAUNCH_POWER = 2.5;
    private static final double BASE_EXPLOSION_RADIUS = 8.0;
    private static final double BASE_EXPLOSION_DAMAGE = 15.0;
    private static final double MAX_VELOCITY_MULTIPLIER = 3.0;
    private static final double VELOCITY_DAMAGE_FACTOR = 0.5;
    private static final float BASE_EXPLOSION_POWER = 2.0f;
    private static final float MAX_EXPLOSION_POWER = 4.0f;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;
    private final Map<UUID, Boolean> inFlight = new HashMap<UUID, Boolean>();
    private final Map<UUID, Double> maxVelocities = new HashMap<UUID, Double>();

    public SkyfallAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 30000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Skyfall", this.cooldowns.get(player.getUniqueId()) + 30000L);
            return;
        }
        this.launchPlayer(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Skyfall", this.cooldowns.get(player.getUniqueId()) + 30000L);
        }
    }

    private void launchPlayer(final Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 1.0f, 1.0f);
        player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 50, 0.5, 0.5, 0.5, 0.1);
        Vector velocity = player.getLocation().getDirection().multiply(0.5).setY(2.5);
        player.setVelocity(velocity);
        this.inFlight.put(player.getUniqueId(), true);
        this.maxVelocities.put(player.getUniqueId(), 0.0);
        new BukkitRunnable(this){
            private int ticks = 0;
            private boolean hasLanded = false;
            final /* synthetic */ SkyfallAbility this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || this.ticks++ > 400) {
                    this.this$0.inFlight.remove(player.getUniqueId());
                    this.this$0.maxVelocities.remove(player.getUniqueId());
                    this.cancel();
                    return;
                }
                double currentVelocity = Math.abs(player.getVelocity().getY());
                if (currentVelocity > this.this$0.maxVelocities.get(player.getUniqueId())) {
                    this.this$0.maxVelocities.put(player.getUniqueId(), currentVelocity);
                }
                if (this.this$0.inFlight.get(player.getUniqueId()).booleanValue() && (player.isOnGround() || this.this$0.isNearGround(player)) && !this.hasLanded) {
                    this.hasLanded = true;
                    this.this$0.createLandingEffect(player);
                    this.this$0.inFlight.remove(player.getUniqueId());
                    this.this$0.maxVelocities.remove(player.getUniqueId());
                    this.cancel();
                } else {
                    player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 5, 0.2, 0.2, 0.2, 0.05);
                }
            }
        }.runTaskTimer(this.plugin, 1L, 1L);
    }

    private boolean isNearGround(Player player) {
        Location loc = player.getLocation();
        return !loc.subtract(0.0, 0.1, 0.0).getBlock().isPassable();
    }

    private void createLandingEffect(Player player) {
        Location landingLoc = player.getLocation();
        double velocityMultiplier = Math.min(this.maxVelocities.get(player.getUniqueId()) * 0.5, 3.0);
        double finalDamage = 15.0 * (1.0 + velocityMultiplier);
        double finalRadius = 8.0 * (1.0 + velocityMultiplier * 0.5);
        float explosionPower = 2.0f + (float)(velocityMultiplier * 2.0 / 3.0);
        player.getWorld().spawnParticle(Particle.EXPLOSION, landingLoc, 30, 3.0, 0.0, 3.0, 0.1);
        player.getWorld().spawnParticle(Particle.FLAME, landingLoc, 50, 3.0, 0.0, 3.0, 0.1);
        player.getWorld().spawnParticle(Particle.CRIT, landingLoc, 100, 3.0, 0.0, 3.0, 0.1);
        player.getWorld().playSound(landingLoc, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.5f);
        player.getWorld().createExplosion(landingLoc, explosionPower, true, true, (Entity)player);
        for (Entity entity : player.getWorld().getNearbyEntities(landingLoc, finalRadius, finalRadius, finalRadius)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            if (entity == player) continue;
            double distance = target.getLocation().distance(landingLoc);
            double damage = finalDamage * (1.0 - distance / finalRadius);
            target.damage(Math.max(1.0, damage), (Entity)player);
            Vector knockback = target.getLocation().subtract(landingLoc).toVector().normalize().multiply(1.5 + velocityMultiplier);
            target.setVelocity(knockback);
        }
        String multiplierText = String.format("%.1fx", 1.0 + velocityMultiplier);
        ActionBarManager.sendMessage(player, "\u00a76Skyfall Impact! \u00a7e(Damage Multiplier: " + multiplierText + ")");
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 30000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

