/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SoulReaverAbility
implements SwordAbility {
    private static final double NORMAL_HEAL = 1.0;
    private static final double CRITICAL_HEAL = 3.0;
    private final Plugin plugin;

    public SoulReaverAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    public void handleAttack(Player attacker, LivingEntity victim, boolean isCritical) {
        Player targetPlayer;
        if (victim instanceof Player && TrustManager.isTrusted(attacker, targetPlayer = (Player)victim)) {
            return;
        }
        double healAmount = isCritical ? 3.0 : 1.0;
        double newHealth = Math.min(attacker.getHealth() + healAmount, attacker.getMaxHealth());
        attacker.setHealth(newHealth);
        this.createSoulEffect(victim.getLocation(), attacker.getLocation());
        attacker.playSound(attacker.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.3f, 2.0f);
        String healText = isCritical ? "1.5\u2764" : "0.5\u2764";
        ActionBarManager.sendMessage(attacker, "\u00a75Soul Absorbed \u00a77(+" + healText + ")");
    }

    private void createSoulEffect(Location start, Location end) {
        double distance = start.distance(end);
        Vector direction = end.toVector().subtract(start.toVector()).normalize();
        for (double d = 0.0; d <= distance; d += 0.5) {
            Location particleLoc = start.clone().add(direction.clone().multiply(d));
            particleLoc.getWorld().spawnParticle(Particle.SOUL, particleLoc, 1, 0.1, 0.1, 0.1, 0.02);
            particleLoc.getWorld().spawnParticle(Particle.DRAGON_BREATH, particleLoc, 1, 0.1, 0.1, 0.1, 0.02);
        }
    }

    @Override
    public void activate(Player player) {
    }

    @Override
    public boolean isOnCooldown(Player player) {
        return false;
    }

    @Override
    public void startCooldown(Player player) {
    }
}

