/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ThunderstrikeAbility
implements SwordAbility,
Listener {
    private static final long COOLDOWN = 1000L;
    private static final double CRITICAL_EXTRA_DAMAGE = 3.0;
    private static final double NORMAL_EXTRA_DAMAGE = 1.0;
    private static final double ACTIVATION_CHANCE = 0.45;
    private static final double RAIN_DAMAGE_MULTIPLIER = 1.5;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> toggledPlayers = new HashMap<UUID, Boolean>();
    private final Plugin plugin;

    public ThunderstrikeAbility(Plugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            return;
        }
        boolean newState = !this.isToggled(player);
        this.toggledPlayers.put(player.getUniqueId(), newState);
        if (newState) {
            ActionBarManager.sendMessage(player, "\u00a7eThunderstrike Mode: \u00a7aEnabled");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
        } else {
            ActionBarManager.sendMessage(player, "\u00a7eThunderstrike Mode: \u00a7cDisabled");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
        }
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
        }
    }

    public void handleAttack(Player attacker, LivingEntity victim, boolean isCritical) {
        Player targetPlayer;
        if (!this.isToggled(attacker)) {
            return;
        }
        if (victim instanceof Player && TrustManager.isTrusted(attacker, targetPlayer = (Player)victim)) {
            return;
        }
        if (Math.random() < 0.45) {
            double extraDamage;
            Location strikeLocation = victim.getLocation();
            victim.getWorld().strikeLightning(strikeLocation);
            double d = extraDamage = isCritical ? 3.0 : 1.0;
            if (victim.getWorld().hasStorm()) {
                extraDamage *= 1.5;
            }
            victim.damage(extraDamage, (Entity)attacker);
            attacker.playSound(attacker.getLocation(), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.5f, 1.0f);
        }
    }

    public boolean isToggled(Player player) {
        return this.toggledPlayers.getOrDefault(player.getUniqueId(), false);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 1000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.LIGHTNING) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem != null && heldItem.hasItemMeta() && heldItem.getItemMeta().hasDisplayName() && heldItem.getItemMeta().getDisplayName().substring(2).equals(CelestialSword.THUNDERSTRIKE.getDisplayName())) {
            event.setCancelled(true);
            player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, player.getLocation(), 20, 0.5, 0.5, 0.5, 0.1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 1.0f);
        }
    }
}

