/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class WardenOathAbility
implements SwordAbility {
    private static final long COOLDOWN = 25000L;
    private static final double SONIC_BOOM_DAMAGE = 30.0;
    private static final double SONIC_BOOM_RANGE = 15.0;
    private static final double SONIC_BOOM_WIDTH = 3.0;
    private static final double HIT_ANGLE = 0.7853981633974483;
    private static final double ANGLE_TOLERANCE = 0.05;
    private static final double MIN_DAMAGE_MULTIPLIER = 0.4;
    private static final double KNOCKBACK_STRENGTH = 1.5;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;

    public WardenOathAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 25000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Warden's Oath", this.cooldowns.get(player.getUniqueId()) + 25000L);
            return;
        }
        this.launchSonicBoom(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Warden's Oath", this.cooldowns.get(player.getUniqueId()) + 25000L);
        }
    }

    private void launchSonicBoom(Player player) {
        Location startLoc = player.getEyeLocation();
        Vector direction = startLoc.getDirection().normalize();
        player.getWorld().playSound(startLoc, Sound.ENTITY_WARDEN_SONIC_BOOM, 2.0f, 1.0f);
        this.visualizeCone(startLoc, direction);
        player.getWorld().getNearbyEntities(startLoc, 15.0, 15.0, 15.0).forEach(entity -> {
            if (entity != player && entity instanceof LivingEntity) {
                Player targetPlayer;
                LivingEntity target = (LivingEntity)entity;
                if (target instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)target)) {
                    return;
                }
                BoundingBox targetBox = target.getBoundingBox();
                Location targetCenter = targetBox.getCenter().toLocation(target.getWorld());
                Vector toTarget = targetCenter.subtract(startLoc).toVector();
                double distance = toTarget.length();
                if (distance <= 15.0 && this.isInCone(direction, toTarget.normalize(), distance)) {
                    double damageMultiplier = this.calculateDamageFalloff(distance);
                    double finalDamage = 30.0 * damageMultiplier;
                    target.damage(finalDamage, (Entity)player);
                    this.applyKnockback(target, player, direction, distance);
                    target.getWorld().spawnParticle(Particle.SONIC_BOOM, targetCenter, 5, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
        ActionBarManager.sendMessage(player, "\u00a7bSonic Boom unleashed!");
    }

    private boolean isInCone(Vector coneDirection, Vector toTarget, double distance) {
        double maxAngleAtDistance;
        double angle = Math.acos(coneDirection.dot(toTarget));
        return angle <= (maxAngleAtDistance = 0.7853981633974483 * (1.0 - distance / 15.0 * 0.5)) + 0.05;
    }

    private double calculateDamageFalloff(double distance) {
        double normalizedDistance = distance / 15.0;
        double falloff = 1.0 - normalizedDistance * normalizedDistance;
        return Math.max(0.4, falloff);
    }

    private void applyKnockback(LivingEntity target, Player source, Vector direction, double distance) {
        double heightDiff = target.getLocation().getY() - source.getLocation().getY();
        double verticalFactor = Math.max(0.2, Math.min(0.8, (heightDiff + 1.0) / 2.0));
        Vector knockback = direction.clone().multiply(1.5 * (1.0 - distance / 15.0));
        knockback.setY(knockback.getY() * verticalFactor + 0.4);
        target.setVelocity(knockback);
    }

    private void visualizeCone(Location start, Vector direction) {
        for (double d = 0.5; d <= 15.0; d += 0.5) {
            double radius = d * Math.tan(0.7853981633974483) * 0.2;
            Location point = start.clone().add(direction.clone().multiply(d));
            for (double angle = 0.0; angle < Math.PI * 2; angle += 0.39269908169872414) {
                double x = Math.cos(angle) * radius;
                double y = Math.sin(angle) * radius;
                Vector perpendicular = direction.clone().crossProduct(new Vector(0, 1, 0)).normalize();
                Vector vertical = direction.clone().crossProduct(perpendicular).normalize();
                Location particleLoc = point.clone().add(perpendicular.clone().multiply(x).add(vertical.clone().multiply(y)));
                start.getWorld().spawnParticle(Particle.SONIC_BOOM, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 25000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

