/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.abilities;

import com.celestialswords.abilities.SwordAbility;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class WindbladeAbility
implements SwordAbility {
    private static final long COOLDOWN = 5000L;
    private static final double DASH_POWER = 1.5;
    private static final double DASH_Y_POWER = 0.5;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Plugin plugin;

    public WindbladeAbility(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void activate(Player player) {
        if (this.shouldApplyCooldown(player) && this.isOnCooldown(player)) {
            long remainingCooldown = (this.cooldowns.get(player.getUniqueId()) + 5000L - System.currentTimeMillis()) / 1000L;
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Wind Blade", this.cooldowns.get(player.getUniqueId()) + 5000L);
            return;
        }
        this.performDash(player);
        if (this.shouldApplyCooldown(player)) {
            this.startCooldown(player);
            ActionBarManager.startPersistentCooldown(this.plugin, player, "Wind Blade", this.cooldowns.get(player.getUniqueId()) + 5000L);
        }
    }

    private void performDash(Player player) {
        Vector direction = player.getLocation().getDirection();
        direction.multiply(1.5).setY(0.5);
        player.setVelocity(direction);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PHANTOM_FLAP, 1.0f, 2.0f);
        this.spawnDashParticles(player.getLocation());
    }

    private void spawnDashParticles(Location location) {
        location.getWorld().spawnParticle(Particle.CLOUD, location, 30, 0.2, 0.0, 0.2, 0.05);
        location.getWorld().spawnParticle(Particle.FIREWORK, location, 10, 0.2, 0.0, 0.2, 0.05);
    }

    public void applySpeedEffect(Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
        ActionBarManager.sendMessage(player, "\u00a7bWind Blade grants you swift movement!");
    }

    public void removeSpeedEffect(Player player) {
        player.removePotionEffect(PotionEffectType.SPEED);
    }

    @Override
    public boolean isOnCooldown(Player player) {
        Long lastUseTime = this.cooldowns.get(player.getUniqueId());
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < 5000L;
    }

    @Override
    public void startCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }
}

