/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.commands;

import com.celestialswords.abilities.AbilityManager;
import com.celestialswords.commands.ReloadCommand;
import com.celestialswords.commands.TriggerCommand;
import com.celestialswords.commands.TrustCommand;
import com.celestialswords.commands.UpdateCommand;
import com.celestialswords.cooldown.CooldownManager;
import com.celestialswords.gui.CraftableGUI;
import com.celestialswords.gui.SwordGUI;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import com.celestialswords.utils.AnnouncementManager;
import com.celestialswords.utils.CommandUtils;
import com.celestialswords.utils.GiveCommandUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RecipeCommand
implements CommandExecutor {
    private final SwordTracker swordTracker;
    private final AbilityManager abilityManager;

    public RecipeCommand(SwordTracker swordTracker, AbilityManager abilityManager) {
        this.swordTracker = swordTracker;
        this.abilityManager = abilityManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            CommandUtils.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "recipes": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                Player player = (Player)sender;
                SwordGUI.openMainGUI(player);
                return true;
            }
            case "reload": {
                return ReloadCommand.handleReload(sender);
            }
            case "give": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /aswords give <player> <sword-name>");
                    return true;
                }
                if (args.length >= 4 && args[3].equalsIgnoreCase("materials")) {
                    return this.handleGiveMaterialsCommand(sender, args);
                }
                return this.handleGiveCommand(sender, args);
            }
            case "trust": {
                return TrustCommand.handleTrust(sender, args);
            }
            case "untrust": {
                return TrustCommand.handleUntrust(sender, args);
            }
            case "help": {
                CommandUtils.sendHelpMessage(sender);
                return true;
            }
            case "creator": {
                CommandUtils.sendCreatorMessage(sender);
                return true;
            }
            case "cooldowns": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                Player player = (Player)sender;
                if (!sender.hasPermission("astral.cooldowns")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                CooldownManager.toggleCooldown(player);
                return true;
            }
            case "trigger": {
                return TriggerCommand.handleTrigger(sender, args);
            }
            case "ability": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                Player player = (Player)sender;
                return this.handleAbilityCommand(player);
            }
            case "craftable": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players!");
                    return true;
                }
                Player player = (Player)sender;
                return this.handleCraftableCommand(player);
            }
            case "craft": {
                if (!sender.hasPermission("astral.togglecraft")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return this.handleCraftCommand(sender, args);
            }
            case "swordannouncements": {
                if (!sender.hasPermission("astral.admin")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return this.handleSwordAnnouncementsCommand(sender, args);
            }
            case "announceplayername": {
                if (!sender.hasPermission("astral.admin")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return this.handleAnnouncePlayerNameCommand(sender, args);
            }
            case "update": {
                if (!sender.hasPermission("astral.admin")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                    return true;
                }
                return UpdateCommand.handleUpdate(sender, args);
            }
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Use /aswords help for available commands.");
        return true;
    }

    private boolean handleGiveCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /aswords give <player> <sword-name>");
            return true;
        }
        if (args[2].equalsIgnoreCase("all") || args[2].equals("*")) {
            if (args[1].equals("*")) {
                Bukkit.getOnlinePlayers().forEach(player -> GiveCommandUtils.giveAllSwords(sender, player));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            GiveCommandUtils.giveAllSwords(sender, target);
            return true;
        }
        if (args[1].equals("*")) {
            String swordName = args[2].replace("-", " ");
            CelestialSword sword = CelestialSword.getByName(swordName);
            if (sword == null) {
                sender.sendMessage("\u00a7cInvalid sword name!");
                return true;
            }
            Bukkit.getOnlinePlayers().forEach(player -> GiveCommandUtils.giveSword(sender, player, sword));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        String swordName = args[2].replace("-", " ");
        CelestialSword sword = CelestialSword.getByName(swordName);
        if (sword == null) {
            sender.sendMessage("\u00a7cInvalid sword name! Available swords:");
            for (CelestialSword s : CelestialSword.values()) {
                sender.sendMessage("\u00a77- \u00a7f" + s.getDisplayName().replace(" ", "-"));
            }
            return true;
        }
        GiveCommandUtils.giveSword(sender, target, sword);
        return true;
    }

    private boolean handleGiveMaterialsCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /aswords give <player> <sword-name> materials");
            return true;
        }
        if (args[1].equals("*")) {
            String swordName = args[2].replace("-", " ");
            CelestialSword sword = CelestialSword.getByName(swordName);
            if (sword == null) {
                sender.sendMessage("\u00a7cInvalid sword name!");
                return true;
            }
            Bukkit.getOnlinePlayers().forEach(player -> GiveCommandUtils.giveMaterials(sender, player, sword));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        String swordName = args[2].replace("-", " ");
        CelestialSword sword = CelestialSword.getByName(swordName);
        if (sword == null) {
            sender.sendMessage("\u00a7cInvalid sword name! Available swords:");
            for (CelestialSword s : CelestialSword.values()) {
                sender.sendMessage("\u00a77- \u00a7f" + s.getDisplayName().replace(" ", "-"));
            }
            return true;
        }
        GiveCommandUtils.giveMaterials(sender, target, sword);
        return true;
    }

    private boolean handleCraftableCommand(Player player) {
        CraftableGUI.openCraftableGUI(player, this.swordTracker);
        return true;
    }

    private boolean handleAbilityCommand(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            player.sendMessage("\u00a7cYou must be holding a Celestial Sword to use this command!");
            return true;
        }
        String itemName = item.getItemMeta().getDisplayName().substring(2);
        CelestialSword sword = CelestialSword.getByName(itemName);
        if (sword == null) {
            player.sendMessage("\u00a7cYou must be holding a Celestial Sword to use this command!");
            return true;
        }
        this.abilityManager.activateAbility(player, sword);
        return true;
    }

    private boolean handleCraftCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /aswords craft <sword-name> <on/off>");
            return true;
        }
        String swordName = args[1].replace("-", " ");
        CelestialSword sword = CelestialSword.getByName(swordName);
        if (sword == null) {
            sender.sendMessage("\u00a7cInvalid sword name! Available swords:");
            for (CelestialSword s : CelestialSword.values()) {
                sender.sendMessage("\u00a77- \u00a7f" + s.getDisplayName().replace(" ", "-"));
            }
            return true;
        }
        String toggle = args[2].toLowerCase();
        if (!toggle.equals("on") && !toggle.equals("off")) {
            sender.sendMessage("\u00a7cInvalid toggle option. Use 'on' or 'off'.");
            return true;
        }
        boolean enabled = toggle.equals("on");
        sword.setCraftingEnabled(enabled);
        String message = enabled ? "\u00a7a" + sword.getDisplayName() + " crafting has been enabled by " + sender.getName() : "\u00a7c" + sword.getDisplayName() + " crafting has been disabled by " + sender.getName();
        Bukkit.broadcastMessage((String)message);
        return true;
    }

    private boolean handleSwordAnnouncementsCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /aswords SwordAnnouncements <on/off>");
            return true;
        }
        String toggle = args[1].toLowerCase();
        if (!toggle.equals("on") && !toggle.equals("off")) {
            sender.sendMessage("\u00a7cInvalid toggle option. Use 'on' or 'off'.");
            return true;
        }
        boolean enabled = toggle.equals("on");
        AnnouncementManager.setSwordAnnouncementsEnabled(enabled);
        sender.sendMessage(enabled ? "\u00a7aSword crafting announcements have been \u00a72enabled\u00a7a." : "\u00a7cSword crafting announcements have been \u00a74disabled\u00a7c.");
        return true;
    }

    private boolean handleAnnouncePlayerNameCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /aswords AnnouncePlayerName <true/false>");
            return true;
        }
        String toggle = args[1].toLowerCase();
        if (!toggle.equals("true") && !toggle.equals("false")) {
            sender.sendMessage("\u00a7cInvalid toggle option. Use 'true' or 'false'.");
            return true;
        }
        boolean enabled = toggle.equals("true");
        AnnouncementManager.setAnnouncePlayerNames(enabled);
        sender.sendMessage(enabled ? "\u00a7aPlayer names will now be \u00a72shown\u00a7a in sword announcements." : "\u00a7cPlayer names will now be \u00a74hidden\u00a7c in sword announcements.");
        return true;
    }
}

