/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.commands;

import com.celestialswords.models.CelestialSword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabCompleter
implements org.bukkit.command.TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("recipes");
            completions.add("craftable");
            completions.add("help");
            completions.add("creator");
            completions.add("trust");
            completions.add("untrust");
            completions.add("cooldowns");
            completions.add("trigger");
            completions.add("ability");
            if (sender.hasPermission("astral.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("astral.give")) {
                completions.add("give");
            }
            if (sender.hasPermission("astral.togglecraft")) {
                completions.add("craft");
            }
            if (sender.hasPermission("astral.admin")) {
                completions.add("swordannouncements");
                completions.add("announceplayername");
                completions.add("update");
            }
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "swordannouncements": {
                    completions.add("on");
                    completions.add("off");
                    break;
                }
                case "announceplayername": {
                    completions.add("true");
                    completions.add("false");
                    break;
                }
                case "update": {
                    completions.add("check");
                    break;
                }
                case "give": {
                    completions.add("*");
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                    break;
                }
                case "trust": 
                case "untrust": {
                    return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
                case "craft": {
                    completions.addAll(Arrays.stream(CelestialSword.values()).map(sword -> sword.getDisplayName().replace(" ", "-")).collect(Collectors.toList()));
                }
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give")) {
                completions.add("all");
                completions.add("*");
                completions.addAll(Arrays.stream(CelestialSword.values()).map(sword -> sword.getDisplayName().replace(" ", "-")).collect(Collectors.toList()));
            } else if (args[0].equalsIgnoreCase("craft")) {
                completions.add("on");
                completions.add("off");
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("give")) {
            completions.add("materials");
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

