/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.commands;

import com.celestialswords.CelestialSwords;
import com.celestialswords.ModrinthUpdater;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateCommand {
    private static final String MODRINTH_PROJECT_ID = "bqBp9WRo";
    private static CelestialSwords plugin;
    private static ModrinthUpdater updater;

    public static void setPlugin(CelestialSwords pluginInstance) {
        plugin = pluginInstance;
    }

    public static boolean handleUpdate(CommandSender sender, String[] args) {
        if (!sender.hasPermission("astral.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("check")) {
                return UpdateCommand.checkForUpdates(sender);
            }
        } else {
            return UpdateCommand.downloadUpdate(sender);
        }
        return false;
    }

    private static boolean checkForUpdates(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Checking for updates...");
        UpdateCommand.updater = new ModrinthUpdater((Plugin)plugin, MODRINTH_PROJECT_ID, plugin.getPluginFile(), false, updater -> {
            switch (updater.getResult()) {
                case UPDATE_AVAILABLE: {
                    if (sender instanceof Player) {
                        updater.sendUpdateNotification((Player)sender);
                        break;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "A new version is available: " + updater.getLatestVersion());
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Use '/cswords update' to download the update.");
                    break;
                }
                case NO_UPDATE: {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "You are running the latest version of CelestialSwords!");
                    break;
                }
                case FAIL_API: 
                case FAIL_BADID: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to check for updates. Could not connect to Modrinth API.");
                    break;
                }
                case FAIL_NOVERSION: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to check for updates. No versions found on Modrinth.");
                    break;
                }
                default: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "An unknown error occurred while checking for updates.");
                }
            }
        });
        return true;
    }

    private static boolean downloadUpdate(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Checking for updates before downloading...");
        UpdateCommand.updater = new ModrinthUpdater((Plugin)plugin, MODRINTH_PROJECT_ID, plugin.getPluginFile(), true, updater -> {
            switch (updater.getResult()) {
                case UPDATE_AVAILABLE: {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Downloading update: " + updater.getLatestVersion());
                    if (updater.downloadUpdate()) {
                        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=========================================");
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CelestialSwords Update Complete. Restart The Server!\ud83d\ude0e");
                        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=========================================");
                        break;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to download the update. Check the console for details.");
                    break;
                }
                case NO_UPDATE: {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "You are already running the latest version of CelestialSwords!");
                    break;
                }
                case FAIL_API: 
                case FAIL_BADID: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to check for updates. Could not connect to Modrinth API.");
                    break;
                }
                case FAIL_NOVERSION: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to check for updates. No versions found on Modrinth.");
                    break;
                }
                default: {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "An unknown error occurred while checking for updates.");
                }
            }
        });
        return true;
    }

    public static void checkForUpdatesInBackground() {
        UpdateCommand.updater = new ModrinthUpdater((Plugin)plugin, MODRINTH_PROJECT_ID, plugin.getPluginFile(), false, updater -> {
            if (updater.getResult() == ModrinthUpdater.UpdateResult.UPDATE_AVAILABLE) {
                updater.broadcastUpdateNotification("astral.admin");
            }
        });
    }
}

