/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.config;

import com.celestialswords.CelestialSwords;
import com.celestialswords.models.CelestialSword;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;

public class ConfigManager {
    private final CelestialSwords plugin;
    private File enchantmentsFile;
    private File recipesFile;
    private FileConfiguration enchantmentsConfig;
    private FileConfiguration recipesConfig;
    private final Map<CelestialSword, Map<Enchantment, Integer>> swordEnchantments = new HashMap<CelestialSword, Map<Enchantment, Integer>>();
    private final Map<CelestialSword, Material[]> swordRecipes = new HashMap<CelestialSword, Material[]>();

    public ConfigManager(CelestialSwords plugin) {
        this.plugin = plugin;
        this.enchantmentsFile = new File(plugin.getDataFolder(), "sword_enchants.yml");
        this.recipesFile = new File(plugin.getDataFolder(), "sword_recipes.yml");
        this.createDefaultConfigs();
        this.loadConfigurations();
    }

    private void createDefaultConfigs() {
        Object path;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.enchantmentsFile.exists()) {
            this.enchantmentsConfig = new YamlConfiguration();
            block11: for (CelestialSword sword : CelestialSword.values()) {
                path = sword.name().toLowerCase();
                this.enchantmentsConfig.set((String)path + ".sharpness", (Object)8);
                this.enchantmentsConfig.set((String)path + ".unbreaking", (Object)4);
                switch (sword) {
                    case DRAGONS_WRATH: 
                    case PHOENIX_TALON: {
                        this.enchantmentsConfig.set((String)path + ".fire_aspect", (Object)5);
                        continue block11;
                    }
                    case SHADOWBANE: {
                        this.enchantmentsConfig.set((String)path + ".bane_of_arthropods", (Object)5);
                        continue block11;
                    }
                    case THUNDERSTRIKE: {
                        this.enchantmentsConfig.set((String)path + ".looting", (Object)5);
                        continue block11;
                    }
                    case VENOM_EDGE: 
                    case ECLIPSE_BLADE: {
                        this.enchantmentsConfig.set((String)path + ".sweeping_edge", (Object)5);
                        continue block11;
                    }
                    case POWER_HOUSE: {
                        this.enchantmentsConfig.set((String)path + ".knockback", (Object)3);
                        this.enchantmentsConfig.set((String)path + ".smite", (Object)5);
                        this.enchantmentsConfig.set((String)path + ".wind_burst", (Object)3);
                    }
                }
            }
            try {
                this.enchantmentsConfig.save(this.enchantmentsFile);
                this.plugin.getLogger().info("Created default sword_enchants.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create default sword_enchants.yml", e);
            }
        }
        if (!this.recipesFile.exists()) {
            this.recipesConfig = new YamlConfiguration();
            for (CelestialSword sword : CelestialSword.values()) {
                path = sword.name().toLowerCase() + ".recipe";
                Material[] defaultRecipe = sword.getRecipe();
                for (int i = 0; i < 9; ++i) {
                    this.recipesConfig.set((String)path + "." + i, (Object)defaultRecipe[i].name());
                }
                this.recipesConfig.set(sword.name().toLowerCase() + ".enabled", (Object)true);
            }
            try {
                this.recipesConfig.save(this.recipesFile);
                this.plugin.getLogger().info("Created default sword_recipes.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create default sword_recipes.yml", e);
            }
        }
    }

    public void loadConfigurations() {
        String path;
        this.swordEnchantments.clear();
        this.swordRecipes.clear();
        this.enchantmentsConfig = YamlConfiguration.loadConfiguration((File)this.enchantmentsFile);
        for (CelestialSword sword : CelestialSword.values()) {
            path = sword.name().toLowerCase();
            ConfigurationSection section = this.enchantmentsConfig.getConfigurationSection(path);
            if (section == null) continue;
            HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            for (String key : section.getKeys(false)) {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key));
                if (enchantment != null) {
                    int level = section.getInt(key);
                    enchants.put(enchantment, level);
                    continue;
                }
                this.plugin.getLogger().warning("Unknown enchantment: " + key + " for sword: " + sword.name());
            }
            this.swordEnchantments.put(sword, enchants);
        }
        this.recipesConfig = YamlConfiguration.loadConfiguration((File)this.recipesFile);
        for (CelestialSword sword : CelestialSword.values()) {
            path = sword.name().toLowerCase();
            ConfigurationSection recipeSection = this.recipesConfig.getConfigurationSection(path + ".recipe");
            if (recipeSection != null) {
                Material[] recipe = new Material[9];
                for (int i = 0; i < 9; ++i) {
                    String materialName = recipeSection.getString(String.valueOf(i));
                    try {
                        if (materialName != null) {
                            recipe[i] = Material.valueOf((String)materialName);
                            continue;
                        }
                        recipe[i] = Material.AIR;
                        this.plugin.getLogger().warning("Missing material for slot " + i + " in recipe for " + sword.name());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        recipe[i] = Material.AIR;
                        this.plugin.getLogger().warning("Invalid material name: " + materialName + " for sword: " + sword.name());
                    }
                }
                this.swordRecipes.put(sword, recipe);
            }
            boolean enabled = this.recipesConfig.getBoolean(path + ".enabled", true);
            sword.setCraftingEnabled(enabled);
        }
        this.plugin.getLogger().info("Loaded sword enchantments and recipes from configuration");
    }

    public void saveConfigurations() {
        try {
            this.enchantmentsConfig.save(this.enchantmentsFile);
            this.recipesConfig.save(this.recipesFile);
            this.plugin.getLogger().info("Saved sword enchantments and recipes to configuration");
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save configurations", e);
        }
    }

    public Map<Enchantment, Integer> getSwordEnchantments(CelestialSword sword) {
        return this.swordEnchantments.getOrDefault((Object)sword, new HashMap());
    }

    public Material[] getSwordRecipe(CelestialSword sword) {
        return this.swordRecipes.getOrDefault((Object)sword, sword.getRecipe());
    }

    public void reloadConfigurations() {
        this.loadConfigurations();
        for (CelestialSword sword : CelestialSword.values()) {
            sword.setConfigRecipe(this.getSwordRecipe(sword));
        }
    }
}

