/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.gui;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import com.celestialswords.utils.GUIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftableGUI {
    public static final String CRAFTABLE_GUI_TITLE = "Available Celestial Swords";
    private static final int ITEMS_PER_PAGE = 7;
    private static final Map<Player, Integer> playerPages = new HashMap<Player, Integer>();

    public static void openCraftableGUI(Player player, SwordTracker swordTracker) {
        List<CelestialSword> craftableSwords = Arrays.stream(CelestialSword.values()).filter(CelestialSword::isCraftingEnabled).filter(sword -> swordTracker.canCraftSword(player, (CelestialSword)((Object)sword))).collect(Collectors.toList());
        playerPages.put(player, 0);
        CraftableGUI.openCraftableGUIPage(player, swordTracker, craftableSwords, 0);
    }

    public static void openCraftableGUIPage(Player player, SwordTracker swordTracker, List<CelestialSword> craftableSwords, int page) {
        ItemStack helpItem;
        ItemMeta helpMeta;
        int size = 27;
        String title = craftableSwords.isEmpty() ? "No Craftable Swords Available" : "Available Celestial Swords (Page " + (page + 1) + ")";
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)title);
        int totalPages = (int)Math.ceil((double)craftableSwords.size() / 7.0);
        totalPages = Math.max(1, totalPages);
        ItemStack infoItem = CraftableGUI.createInfoItem(craftableSwords.size());
        gui.setItem(0, infoItem);
        int startIndex = page * 7;
        int endIndex = Math.min(startIndex + 7, craftableSwords.size());
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16};
        for (int i = startIndex; i < endIndex; ++i) {
            int slotIndex = i - startIndex;
            if (slotIndex >= slots.length) continue;
            CelestialSword sword = craftableSwords.get(i);
            gui.setItem(slots[slotIndex], CraftableGUI.createEnhancedSwordItem(sword, true));
        }
        if (totalPages > 1) {
            if (page > 0) {
                gui.setItem(18, CraftableGUI.createNavigationItem(Material.ARROW, "\u00a7e\u2190 Previous Page"));
            }
            if (page < totalPages - 1) {
                gui.setItem(26, CraftableGUI.createNavigationItem(Material.ARROW, "\u00a7eNext Page \u2192"));
            }
            ItemStack pageIndicator = CraftableGUI.createNavigationItem(Material.PAPER, "\u00a7ePage " + (page + 1) + " of " + totalPages);
            gui.setItem(22, pageIndicator);
        }
        if ((helpMeta = (helpItem = CraftableGUI.createNavigationItem(Material.BOOK, "\u00a76How to Craft")).getItemMeta()) != null) {
            ArrayList<String> helpLore = new ArrayList<String>();
            helpLore.add("\u00a77Click on a sword to see its recipe");
            helpLore.add("\u00a77Craft the sword using the shown materials");
            helpLore.add("\u00a77Each sword can only be crafted once on the server");
            helpMeta.setLore(helpLore);
            helpItem.setItemMeta(helpMeta);
        }
        gui.setItem(8, helpItem);
        playerPages.put(player, page);
        player.openInventory(gui);
    }

    private static ItemStack createEnhancedSwordItem(CelestialSword sword, boolean includeRecipeHint) {
        ItemStack item = GUIUtils.createSwordItem(sword, includeRecipeHint);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore() != null ? new ArrayList<String>(meta.getLore()) : new ArrayList();
            lore.add("\u00a76\u00a7m--------------------");
            lore.add("\u00a76Crafting Requirements:");
            lore.add("\u00a77- Crafting Table");
            lore.add("\u00a77- Required Materials (click to view)");
            lore.add("\u00a77- Each sword can only be crafted once");
            lore.add("\u00a76\u00a7m--------------------");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack createInfoItem(int availableSwords) {
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76Craftable Celestial Swords");
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77These are the swords you can craft");
            lore.add("\u00a77Available swords: \u00a7e" + availableSwords);
            lore.add("\u00a77");
            lore.add("\u00a77Each sword can only be crafted");
            lore.add("\u00a77once on the entire server!");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack createNavigationItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static boolean handleNavigation(Player player, SwordTracker swordTracker, int slot) {
        List<CelestialSword> craftableSwords;
        int totalPages;
        if (!playerPages.containsKey(player)) {
            return false;
        }
        int currentPage = playerPages.get(player);
        if (slot == 18 && currentPage > 0) {
            List<CelestialSword> craftableSwords2 = Arrays.stream(CelestialSword.values()).filter(CelestialSword::isCraftingEnabled).filter(sword -> swordTracker.canCraftSword(player, (CelestialSword)((Object)sword))).collect(Collectors.toList());
            CraftableGUI.openCraftableGUIPage(player, swordTracker, craftableSwords2, currentPage - 1);
            return true;
        }
        if (slot == 26 && currentPage < (totalPages = (int)Math.ceil((double)(craftableSwords = Arrays.stream(CelestialSword.values()).filter(CelestialSword::isCraftingEnabled).filter(sword -> swordTracker.canCraftSword(player, (CelestialSword)((Object)sword))).collect(Collectors.toList())).size() / 7.0)) - 1) {
            CraftableGUI.openCraftableGUIPage(player, swordTracker, craftableSwords, currentPage + 1);
            return true;
        }
        return false;
    }
}

