/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.gui;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.utils.GUIUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class SwordGUI {
    public static final String MAIN_GUI_TITLE = "Astral Swords Recipes";

    public static void openMainGUI(Player player) {
        CelestialSword[] enabledSwords = (CelestialSword[])Arrays.stream(CelestialSword.values()).filter(CelestialSword::isCraftingEnabled).toArray(CelestialSword[]::new);
        int totalSwords = enabledSwords.length;
        int rows = Math.max(1, (totalSwords + 8) / 9);
        int size = rows * 9;
        Inventory gui = Bukkit.createInventory(null, (int)size, (String)MAIN_GUI_TITLE);
        for (int i = 0; i < enabledSwords.length; ++i) {
            gui.setItem(i, GUIUtils.createSwordItem(enabledSwords[i], true));
        }
        player.openInventory(gui);
    }

    public static void openRecipeGUI(Player player, CelestialSword sword) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)sword.getRecipeTitle());
        sword.fillRecipeInventory(gui);
        player.openInventory(gui);
    }
}

