/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.gui;

import com.celestialswords.models.CelestialSword;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SwordSelectionGUI {
    public static final String SELECTION_GUI_TITLE = "Choose Your Sword";
    private static final Map<UUID, Item> pendingGroundItems = new HashMap<UUID, Item>();

    public static void openSelectionGUI(Player player, ItemStack currentSword, Item groundItem) {
        pendingGroundItems.put(player.getUniqueId(), groundItem);
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)SELECTION_GUI_TITLE);
        gui.setItem(11, SwordSelectionGUI.createDisplayItem(currentSword, "\u00a7aKeep This Sword", "\u00a77This is the sword you currently have", "\u00a77Click to keep this sword and close the GUI"));
        ItemStack groundSword = groundItem.getItemStack();
        gui.setItem(15, SwordSelectionGUI.createDisplayItem(groundSword, "\u00a7eTake This Sword", "\u00a77This is the sword on the ground", "\u00a7cYour current sword will be deleted", "\u00a77Click to take this sword"));
        ItemStack divider = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta dividerMeta = divider.getItemMeta();
        dividerMeta.setDisplayName("\u00a78Choose one sword");
        divider.setItemMeta(dividerMeta);
        for (int i = 0; i < 27; ++i) {
            if (i == 11 || i == 15 || gui.getItem(i) != null) continue;
            gui.setItem(i, divider);
        }
        player.openInventory(gui);
    }

    private static ItemStack createDisplayItem(ItemStack baseItem, String title, String ... loreLines) {
        ItemStack displayItem = baseItem.clone();
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            ArrayList<String> lore = new ArrayList<String>();
            if (meta.hasLore() && meta.getLore() != null) {
                lore.addAll(meta.getLore());
                lore.add("\u00a78-----------------");
            }
            for (String line : loreLines) {
                lore.add(line);
            }
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
        }
        return displayItem;
    }

    public static boolean handleSelection(Player player, int slot) {
        if (slot == 11) {
            player.sendMessage("\u00a7aYou chose to keep your current sword.");
            pendingGroundItems.remove(player.getUniqueId());
            return true;
        }
        if (slot == 15) {
            Item groundItem = pendingGroundItems.get(player.getUniqueId());
            if (groundItem != null && !groundItem.isDead()) {
                for (int i = 0; i < player.getInventory().getSize(); ++i) {
                    String itemName;
                    ItemStack item = player.getInventory().getItem(i);
                    if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || CelestialSword.getByName(itemName = item.getItemMeta().getDisplayName().substring(2)) == null) continue;
                    player.getInventory().setItem(i, null);
                    break;
                }
                ItemStack groundSword = groundItem.getItemStack().clone();
                player.getInventory().addItem(new ItemStack[]{groundSword});
                groundItem.remove();
                player.sendMessage("\u00a7aYou chose to take the new sword. Your old sword has been deleted.");
            } else {
                player.sendMessage("\u00a7cThe sword on the ground is no longer available.");
            }
            pendingGroundItems.remove(player.getUniqueId());
            return true;
        }
        return false;
    }

    public static boolean hasPendingSelection(Player player) {
        return pendingGroundItems.containsKey(player.getUniqueId());
    }

    public static void removePendingSelection(Player player) {
        pendingGroundItems.remove(player.getUniqueId());
    }
}

