/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.abilities.AbilityManager;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.utils.TriggerManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;

public class AbilityListener
implements Listener {
    private final AbilityManager abilityManager;

    public AbilityListener(AbilityManager abilityManager) {
        this.abilityManager = abilityManager;
    }

    private boolean checkAndActivateSword(Player player) {
        String itemName;
        CelestialSword sword;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = item.getItemMeta().getDisplayName().substring(2))) != null) {
            boolean abilityActivated = this.abilityManager.activateAbility(player, sword);
            if (abilityActivated) {
                this.abilityManager.playActivationEffect(player, sword);
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onKeyPress(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        if (trigger.equals("F")) {
            event.setCancelled(true);
            this.checkAndActivateSword(player);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        if (trigger.equals("Q") && this.checkAndActivateSword(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        if (!event.isSneaking()) {
            return;
        }
        if (trigger.equals("SHIFT")) {
            this.checkAndActivateSword(player);
        }
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        if (!event.isSprinting()) {
            return;
        }
        if (trigger.equals("CTRL")) {
            this.checkAndActivateSword(player);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        switch (event.getAction()) {
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (!trigger.equals("RIGHT_CLICK") || !this.checkAndActivateSword(player)) break;
                event.setCancelled(true);
                break;
            }
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                if (!trigger.equals("LEFT_CLICK") || !this.checkAndActivateSword(player)) break;
                event.setCancelled(true);
                break;
            }
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        String trigger = TriggerManager.getPlayerTrigger(player);
        if (trigger.equals("SCROLL")) {
            this.checkAndActivateSword(player);
        }
    }
}

