/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import java.util.Iterator;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

public class ContainerProtectionListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clickedItem;
        ItemStack hotbarItem;
        int hotbarSlot;
        ItemStack cursorItem;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (title.equals("Astral Swords Recipes") || title.equals("Available Celestial Swords") || title.endsWith("Recipe")) {
            return;
        }
        if (event.getClickedInventory() != null && event.getClickedInventory().getType() != InventoryType.PLAYER && (cursorItem = event.getCursor()) != null && this.isCelestialSword(cursorItem) && event.getClickedInventory().getType() != InventoryType.ANVIL) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cCelestial Swords can only be placed in anvils, not other containers.");
            return;
        }
        if (event.getClick() == ClickType.NUMBER_KEY && event.getClickedInventory() != null && event.getClickedInventory().getType() != InventoryType.PLAYER && (hotbarSlot = event.getHotbarButton()) >= 0 && hotbarSlot < 9 && (hotbarItem = player.getInventory().getItem(hotbarSlot)) != null && this.isCelestialSword(hotbarItem) && event.getClickedInventory().getType() != InventoryType.ANVIL) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cCelestial Swords can only be placed in anvils, not other containers.");
            return;
        }
        if (event.getClick().isShiftClick() && event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.PLAYER && (clickedItem = event.getCurrentItem()) != null && this.isCelestialSword(clickedItem) && event.getView().getTopInventory().getType() != InventoryType.PLAYER && event.getView().getTopInventory().getType() != InventoryType.CRAFTING && event.getView().getTopInventory().getType() != InventoryType.ANVIL) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cCelestial Swords can only be placed in anvils, not other containers.");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack draggedItem = event.getOldCursor();
        if (draggedItem != null && this.isCelestialSword(draggedItem)) {
            boolean draggedToContainer = false;
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= event.getView().getTopInventory().getSize() || event.getView().getTopInventory().getType() == InventoryType.PLAYER || event.getView().getTopInventory().getType() == InventoryType.CRAFTING || event.getView().getTopInventory().getType() == InventoryType.ANVIL) continue;
                draggedToContainer = true;
                break;
            }
            if (draggedToContainer) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cCelestial Swords can only be placed in anvils, not other containers.");
            }
        }
    }

    private boolean isCelestialSword(ItemStack item) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            String itemName = item.getItemMeta().getDisplayName().substring(2);
            return CelestialSword.getByName(itemName) != null;
        }
        return false;
    }
}

