/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import com.celestialswords.utils.AnnouncementManager;
import com.celestialswords.utils.GUIUtils;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CraftingListener
implements Listener {
    private final SwordTracker swordTracker;
    private final Plugin plugin;

    public CraftingListener(SwordTracker swordTracker, Plugin plugin) {
        this.swordTracker = swordTracker;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        HumanEntity humanEntity = event.getView().getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        if (this.isEmpty(matrix)) {
            return;
        }
        for (CelestialSword sword : CelestialSword.values()) {
            if (!this.matchesRecipe(matrix, sword)) continue;
            if (!player.hasPermission("astral.craft")) {
                player.sendMessage("\u00a7cYou don't have permission to craft celestial swords.");
                inventory.setResult(null);
                return;
            }
            if (!this.swordTracker.canCraftSword(player, sword)) {
                player.sendMessage("\u00a7cThe " + sword.getDisplayName() + "\u00a7c already exists in the world! Each sword can only be crafted once on the server.");
                inventory.setResult(null);
                return;
            }
            inventory.setResult(GUIUtils.createSwordItem(sword, false));
            return;
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        String itemName;
        CelestialSword sword;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack result = event.getCurrentItem();
        if (result != null && result.hasItemMeta() && result.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = result.getItemMeta().getDisplayName().substring(2))) != null) {
            if (!player.hasPermission("astral.craft")) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou don't have permission to craft celestial swords.");
                return;
            }
            if (!this.swordTracker.canCraftSword(player, sword)) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cThe " + sword.getDisplayName() + "\u00a7c already exists in the world! Each sword can only be crafted once on the server.");
                return;
            }
            this.handleSwordCrafting(player, result, sword);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String itemName;
        CelestialSword sword;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)humanEntity;
        if (event.getClickedInventory() == null || event.getClickedInventory().getType() != InventoryType.WORKBENCH || event.getSlot() != 0) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && clickedItem.hasItemMeta() && clickedItem.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = clickedItem.getItemMeta().getDisplayName().substring(2))) != null) {
            if (!player.hasPermission("astral.craft")) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou don't have permission to craft celestial swords.");
                return;
            }
            if (!this.swordTracker.canCraftSword(player, sword)) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cThe " + sword.getDisplayName() + "\u00a7c already exists in the world! Each sword can only be crafted once on the server.");
                return;
            }
            new BukkitRunnable(this){
                final /* synthetic */ CraftingListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    for (ItemStack item : player.getInventory().getContents()) {
                        if (!this.this$0.isCelestialSword(item, sword)) continue;
                        this.this$0.handleSwordCrafting(player, item, sword);
                        break;
                    }
                }
            }.runTaskLater(this.plugin, 1L);
        }
    }

    private void handleSwordCrafting(Player player, ItemStack swordItem, CelestialSword sword) {
        this.swordTracker.trackSword(player, swordItem, sword);
        player.sendMessage("\u00a7aYou have crafted the " + sword.getDisplayName() + "\u00a7a!");
        AnnouncementManager.announceSwordCrafting(player, sword);
    }

    private boolean isCelestialSword(ItemStack item, CelestialSword sword) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        String itemName = item.getItemMeta().getDisplayName().substring(2);
        return sword.getDisplayName().equals(itemName);
    }

    private boolean isEmpty(ItemStack[] matrix) {
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    private boolean matchesRecipe(ItemStack[] matrix, CelestialSword sword) {
        Material[] recipe = sword.getRecipe();
        for (int i = 0; i < 9; ++i) {
            ItemStack item = matrix[i];
            Material required = recipe[i];
            if ((item == null || item.getType() == Material.AIR) && required == Material.AIR || item != null && item.getType() == required) continue;
            return false;
        }
        return true;
    }
}

