/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.gui.CraftableGUI;
import com.celestialswords.gui.SwordGUI;
import com.celestialswords.gui.SwordSelectionGUI;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class GUIListener
implements Listener {
    private final SwordTracker swordTracker;

    public GUIListener(SwordTracker swordTracker) {
        this.swordTracker = swordTracker;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (title.equals("Astral Swords Recipes") || title.startsWith("Available Celestial Swords") || title.equals("No Craftable Swords Available") || title.equals("Choose Your Sword") || title.endsWith("Recipe")) {
            event.setCancelled(true);
            if (title.equals("Choose Your Sword")) {
                if (event.getCurrentItem() != null) {
                    SwordSelectionGUI.handleSelection(player, event.getSlot());
                    player.closeInventory();
                }
            } else if (title.equals("Astral Swords Recipes")) {
                String swordName;
                CelestialSword sword;
                if (event.getCurrentItem() != null && event.getCurrentItem().hasItemMeta() && (sword = CelestialSword.getByName(swordName = event.getCurrentItem().getItemMeta().getDisplayName().substring(2))) != null) {
                    SwordGUI.openRecipeGUI(player, sword);
                }
            } else if (title.startsWith("Available Celestial Swords") || title.equals("No Craftable Swords Available")) {
                String swordName;
                CelestialSword sword;
                String displayName;
                if (CraftableGUI.handleNavigation(player, this.swordTracker, event.getSlot())) {
                    return;
                }
                if (event.getCurrentItem() != null && event.getCurrentItem().hasItemMeta() && event.getCurrentItem().getItemMeta().hasDisplayName() && (displayName = event.getCurrentItem().getItemMeta().getDisplayName()).startsWith("\u00a76") && !displayName.equals("\u00a76Craftable Celestial Swords") && !displayName.equals("\u00a76How to Craft") && (sword = CelestialSword.getByName(swordName = displayName.substring(2))) != null) {
                    SwordGUI.openRecipeGUI(player, sword);
                }
            } else if (title.endsWith("Recipe") && event.getSlot() == 26) {
                SwordGUI.openMainGUI(player);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (title.equals("Choose Your Sword")) {
            SwordSelectionGUI.removePendingSelection(player);
        }
    }
}

