/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class InventoryMoveListener
implements Listener {
    private final SwordTracker swordTracker;
    private static final Permission MULTI_SWORD_PERMISSION = new Permission("astral.multisword", "Allows players to hold more than one celestial sword", PermissionDefault.FALSE);

    public InventoryMoveListener(SwordTracker swordTracker) {
        this.swordTracker = swordTracker;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursorItem;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        if (title.equals("Astral Swords Recipes") || title.equals("Available Celestial Swords") || title.endsWith("Recipe")) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && this.isCelestialSword(clickedItem) && !player.hasPermission(MULTI_SWORD_PERMISSION) && this.hasOtherCelestialSword(player, clickedItem)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot hold more than one Celestial Sword at a time.");
            player.closeInventory();
        }
        if ((cursorItem = event.getCursor()) != null && this.isCelestialSword(cursorItem) && !player.hasPermission(MULTI_SWORD_PERMISSION) && this.hasOtherCelestialSword(player, cursorItem)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot hold more than one Celestial Sword at a time.");
            player.closeInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack draggedItem = event.getOldCursor();
        if (draggedItem != null && this.isCelestialSword(draggedItem) && !player.hasPermission(MULTI_SWORD_PERMISSION) && this.hasOtherCelestialSword(player, draggedItem)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot hold more than one Celestial Sword at a time.");
            player.closeInventory();
        }
    }

    private boolean isCelestialSword(ItemStack item) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            String itemName = item.getItemMeta().getDisplayName().substring(2);
            return CelestialSword.getByName(itemName) != null;
        }
        return false;
    }

    private boolean hasOtherCelestialSword(Player player, ItemStack excludeItem) {
        if (excludeItem != null && this.isCelestialSword(excludeItem)) {
            String excludeSwordName = excludeItem.getItemMeta().getDisplayName().substring(2);
            CelestialSword excludeSword = CelestialSword.getByName(excludeSwordName);
            int sameTypeCount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || !this.isCelestialSword(item)) continue;
                String itemName = item.getItemMeta().getDisplayName().substring(2);
                CelestialSword itemSword = CelestialSword.getByName(itemName);
                if (itemSword != excludeSword) {
                    return true;
                }
                if (itemSword != excludeSword) continue;
                ++sameTypeCount;
            }
            return sameTypeCount > 1;
        }
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item == excludeItem || !this.isCelestialSword(item)) continue;
            return true;
        }
        return false;
    }
}

