/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;

public class ItemFrameProtectionListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!(event.getRightClicked() instanceof ItemFrame) && !(event.getRightClicked() instanceof GlowItemFrame)) {
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand != null && this.isCelestialSword(itemInHand)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cCelestial Swords cannot be placed in item frames.");
            return;
        }
        ItemStack itemInOffHand = player.getInventory().getItemInOffHand();
        if (itemInOffHand != null && this.isCelestialSword(itemInOffHand)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cCelestial Swords cannot be placed in item frames.");
        }
    }

    private boolean isCelestialSword(ItemStack item) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            String itemName = item.getItemMeta().getDisplayName().substring(2);
            return CelestialSword.getByName(itemName) != null;
        }
        return false;
    }
}

