/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.trust.TrustManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class MaceEffectListener
implements Listener {
    private static final double DAMAGE_MULTIPLIER = 0.5;
    private static final double MAX_BONUS_DAMAGE = 10.0;
    private final Map<UUID, Double> fallingPlayers = new HashMap<UUID, Double>();

    @EventHandler
    public void onPlayerFall(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        double fallDamage = event.getDamage();
        this.fallingPlayers.put(player.getUniqueId(), fallDamage);
        Bukkit.getScheduler().runTaskLater(Bukkit.getPluginManager().getPlugin("AstralSwords"), () -> this.fallingPlayers.remove(player.getUniqueId()), 40L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player victim;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        ItemStack item = attacker.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = item.getItemMeta().getDisplayName().substring(2);
        if (!itemName.equals(CelestialSword.POWER_HOUSE.getDisplayName())) {
            return;
        }
        Double fallDamage = this.fallingPlayers.get(attacker.getUniqueId());
        if (fallDamage == null || fallDamage <= 0.0) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player && TrustManager.isTrusted(attacker, victim = (Player)entity2)) {
            return;
        }
        double bonusDamage = Math.min(fallDamage * 0.5, 10.0);
        event.setDamage(event.getDamage() + bonusDamage);
        Entity target = event.getEntity();
        target.getWorld().spawnParticle(Particle.CRIT, target.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.1);
        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_PLAYER_ATTACK_CRIT, 1.0f, 0.8f);
        this.fallingPlayers.remove(attacker.getUniqueId());
    }
}

