/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.abilities.AbilityManager;
import com.celestialswords.abilities.EclipseBlade;
import com.celestialswords.listeners.SwordEffectsListener;
import com.celestialswords.models.CelestialSword;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerCleanupListener
implements Listener {
    private final AbilityManager abilityManager;
    private final SwordEffectsListener swordEffectsListener;

    public PlayerCleanupListener(AbilityManager abilityManager, SwordEffectsListener swordEffectsListener) {
        this.abilityManager = abilityManager;
        this.swordEffectsListener = swordEffectsListener;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        EclipseBlade eclipseBlade = (EclipseBlade)this.abilityManager.getAbility(CelestialSword.ECLIPSE_BLADE);
        if (eclipseBlade != null) {
            eclipseBlade.onPlayerQuitOrDeath(player);
        }
        this.swordEffectsListener.cleanupEclipseBladeData(player);
    }
}

