/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.abilities.AbilityManager;
import com.celestialswords.abilities.EclipseBlade;
import com.celestialswords.abilities.SoulReaverAbility;
import com.celestialswords.abilities.ThunderstrikeAbility;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.trust.TrustManager;
import com.celestialswords.utils.ActionBarManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SwordEffectsListener
implements Listener {
    private final Map<UUID, Long> venomCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Long> shadowbaneCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> eclipseBladeThrownMap = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> eclipseBladeRemainingTime = new HashMap<UUID, Integer>();
    private final Map<UUID, PotionEffectType> activeSwordEffects = new HashMap<UUID, PotionEffectType>();
    private final Plugin plugin;
    private final AbilityManager abilityManager;
    private BukkitRunnable swordEffectTask;

    public SwordEffectsListener(Plugin plugin, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.abilityManager = abilityManager;
        this.startSwordEffectTask();
    }

    private void startSwordEffectTask() {
        this.swordEffectTask = new BukkitRunnable(){

            public void run() {
                for (Player player : SwordEffectsListener.this.plugin.getServer().getOnlinePlayers()) {
                    ItemStack mainHandItem = player.getInventory().getItemInMainHand();
                    boolean hasPhoenixTalon = SwordEffectsListener.this.isPhoenixTalon(mainHandItem);
                    boolean hasWindblade = SwordEffectsListener.this.isWindblade(mainHandItem);
                    PotionEffectType currentEffect = SwordEffectsListener.this.activeSwordEffects.get(player.getUniqueId());
                    if (hasPhoenixTalon) {
                        if (player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) continue;
                        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
                        SwordEffectsListener.this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.FIRE_RESISTANCE);
                        continue;
                    }
                    if (hasWindblade) {
                        if (player.hasPotionEffect(PotionEffectType.SPEED)) continue;
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
                        SwordEffectsListener.this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.SPEED);
                        continue;
                    }
                    if (currentEffect == null || !player.hasPotionEffect(currentEffect)) continue;
                    player.removePotionEffect(currentEffect);
                    SwordEffectsListener.this.activeSwordEffects.remove(player.getUniqueId());
                }
            }
        };
        this.swordEffectTask.runTaskTimer(this.plugin, 0L, 100L);
    }

    public void stopSwordEffectTask() {
        if (this.swordEffectTask != null && !this.swordEffectTask.isCancelled()) {
            this.swordEffectTask.cancel();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        block10: {
            String weaponName;
            ItemStack weapon;
            block11: {
                Player targetPlayer;
                Entity entity = event.getDamager();
                if (!(entity instanceof Player)) {
                    return;
                }
                Player player = (Player)entity;
                Entity entity2 = event.getEntity();
                if (entity2 instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)entity2)) {
                    event.setCancelled(true);
                    return;
                }
                weapon = player.getInventory().getItemInMainHand();
                if (!weapon.hasItemMeta() || !weapon.getItemMeta().hasDisplayName()) {
                    return;
                }
                weaponName = weapon.getItemMeta().getDisplayName().substring(2);
                boolean isCritical = player.getFallDistance() > 0.0f && !player.isOnGround();
                Entity entity3 = event.getEntity();
                if (!(entity3 instanceof LivingEntity)) break block10;
                LivingEntity victim = (LivingEntity)entity3;
                CelestialSword sword = CelestialSword.getByName(weaponName);
                if (sword == null) break block11;
                switch (sword) {
                    case VENOM_EDGE: {
                        this.handleVenomEdgeEffect(player, victim);
                        break;
                    }
                    case SHADOWBANE: {
                        this.handleShadowbaneEffect(player, victim);
                        break;
                    }
                    case THUNDERSTRIKE: {
                        ThunderstrikeAbility ability = (ThunderstrikeAbility)this.abilityManager.getAbility(CelestialSword.THUNDERSTRIKE);
                        if (ability != null) {
                            ability.handleAttack(player, victim, isCritical);
                            break;
                        }
                        break block10;
                    }
                    case SOUL_REAVER: {
                        SoulReaverAbility ability = (SoulReaverAbility)this.abilityManager.getAbility(CelestialSword.SOUL_REAVER);
                        if (ability == null) break;
                        ability.handleAttack(player, victim, isCritical);
                    }
                }
                break block10;
            }
            this.plugin.getLogger().warning("Unknown celestial sword name: '" + weaponName + "' (original display name: '" + weapon.getItemMeta().getDisplayName() + "')");
        }
    }

    private void handleVenomEdgeEffect(Player player, LivingEntity victim) {
        Player targetPlayer;
        if (victim instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)victim)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (this.venomCooldowns.containsKey(playerId) && System.currentTimeMillis() - this.venomCooldowns.get(playerId) < 20000L) {
            return;
        }
        this.venomCooldowns.put(playerId, System.currentTimeMillis());
        victim.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 1));
        ActionBarManager.sendMessage(player, "\u00a72Venom Edge effect applied!");
    }

    private void handleShadowbaneEffect(Player player, LivingEntity victim) {
        Player targetPlayer;
        if (victim instanceof Player && TrustManager.isTrusted(player, targetPlayer = (Player)victim)) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (this.shadowbaneCooldowns.containsKey(playerId) && System.currentTimeMillis() - this.shadowbaneCooldowns.get(playerId) < 20000L) {
            return;
        }
        this.shadowbaneCooldowns.put(playerId, System.currentTimeMillis());
        victim.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
        ActionBarManager.sendMessage(player, "\u00a78Shadowbane effect applied!");
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        ItemStack oldItem = player.getInventory().getItem(event.getPreviousSlot());
        if (this.isWindblade(oldItem) && !this.isWindblade(newItem)) {
            if (this.activeSwordEffects.get(player.getUniqueId()) == PotionEffectType.SPEED) {
                player.removePotionEffect(PotionEffectType.SPEED);
                this.activeSwordEffects.remove(player.getUniqueId());
            }
        } else if (this.isWindblade(newItem) && !player.hasPotionEffect(PotionEffectType.SPEED)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
            this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.SPEED);
        }
        if (this.isPhoenixTalon(oldItem) && !this.isPhoenixTalon(newItem)) {
            if (this.activeSwordEffects.get(player.getUniqueId()) == PotionEffectType.FIRE_RESISTANCE) {
                player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
                this.activeSwordEffects.remove(player.getUniqueId());
            }
        } else if (this.isPhoenixTalon(newItem) && !player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
            this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.FIRE_RESISTANCE);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item droppedItem = event.getItemDrop();
        ItemStack itemStack = droppedItem.getItemStack();
        if (this.isEclipseBlade(itemStack)) {
            this.eclipseBladeThrownMap.put(player.getUniqueId(), true);
            if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                PotionEffect invisibilityEffect = player.getPotionEffect(PotionEffectType.INVISIBILITY);
                if (invisibilityEffect != null) {
                    this.eclipseBladeRemainingTime.put(player.getUniqueId(), invisibilityEffect.getDuration());
                }
                player.removePotionEffect(PotionEffectType.INVISIBILITY);
                ActionBarManager.sendMessage(player, "\u00a75Eclipse Blade: \u00a7cInvisibility Removed (Sword Thrown)");
                EclipseBlade ability = (EclipseBlade)this.abilityManager.getAbility(CelestialSword.ECLIPSE_BLADE);
                if (ability != null) {
                    ability.removeInvisibility(player);
                }
            }
        }
        if (this.isPhoenixTalon(itemStack) && this.activeSwordEffects.get(player.getUniqueId()) == PotionEffectType.FIRE_RESISTANCE) {
            player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
            this.activeSwordEffects.remove(player.getUniqueId());
        }
        if (this.isWindblade(itemStack) && this.activeSwordEffects.get(player.getUniqueId()) == PotionEffectType.SPEED) {
            player.removePotionEffect(PotionEffectType.SPEED);
            this.activeSwordEffects.remove(player.getUniqueId());
        }
    }

    public boolean hasEclipseBlade(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.isEclipseBlade(item)) continue;
            return true;
        }
        return false;
    }

    private boolean isEclipseBlade(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().substring(2).equals(CelestialSword.ECLIPSE_BLADE.getDisplayName());
    }

    private boolean isWindblade(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().substring(2).equals(CelestialSword.WINDBLADE.getDisplayName());
    }

    private boolean isPhoenixTalon(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().substring(2).equals(CelestialSword.PHOENIX_TALON.getDisplayName());
    }

    public void cleanupEclipseBladeData(Player player) {
        this.eclipseBladeThrownMap.remove(player.getUniqueId());
        this.eclipseBladeRemainingTime.remove(player.getUniqueId());
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem();
        ItemStack itemStack = item.getItemStack();
        if (this.isEclipseBlade(itemStack)) {
            Boolean wasThrown = this.eclipseBladeThrownMap.get(player.getUniqueId());
            Integer remainingTime = this.eclipseBladeRemainingTime.get(player.getUniqueId());
            if (wasThrown != null && wasThrown.booleanValue() && remainingTime != null && remainingTime > 0) {
                EclipseBlade ability = (EclipseBlade)this.abilityManager.getAbility(CelestialSword.ECLIPSE_BLADE);
                if (ability != null) {
                    this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                        if (this.hasEclipseBlade(player)) {
                            this.eclipseBladeThrownMap.put(player.getUniqueId(), false);
                            int timeToApply = this.eclipseBladeRemainingTime.remove(player.getUniqueId());
                            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, timeToApply, 0, false, false, true));
                            EclipseBlade eclipseAbility = (EclipseBlade)this.abilityManager.getAbility(CelestialSword.ECLIPSE_BLADE);
                            if (eclipseAbility != null) {
                                eclipseAbility.getInvisibilityActive().put(player.getUniqueId(), true);
                                int n = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
                                    if (eclipseAbility.getInvisibilityActive().getOrDefault(player.getUniqueId(), false).booleanValue()) {
                                        eclipseAbility.startCooldown(player);
                                        ActionBarManager.startPersistentCooldown(this.plugin, player, "Eclipse Blade", System.currentTimeMillis() + 20000L);
                                        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                                            if (onlinePlayer.equals((Object)player)) continue;
                                            onlinePlayer.showPlayer(this.plugin, player);
                                        }
                                        eclipseAbility.getInvisibilityActive().put(player.getUniqueId(), false);
                                    }
                                }, (long)timeToApply).getTaskId();
                            }
                            ActionBarManager.sendMessage(player, "\u00a75Eclipse Blade: \u00a7aInvisibility Restored (" + timeToApply / 20 + "s remaining)");
                        }
                    });
                }
            } else {
                this.eclipseBladeThrownMap.remove(player.getUniqueId());
                this.eclipseBladeRemainingTime.remove(player.getUniqueId());
            }
        }
        if (this.isPhoenixTalon(itemStack) && !player.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0, false, false));
            this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.FIRE_RESISTANCE);
        }
        if (this.isWindblade(itemStack) && !player.hasPotionEffect(PotionEffectType.SPEED)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false));
            this.activeSwordEffects.put(player.getUniqueId(), PotionEffectType.SPEED);
        }
    }
}

