/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SwordLifecycleListener
implements Listener {
    private final SwordTracker swordTracker;
    private final Plugin plugin;
    private final Map<UUID, ItemStack> trackedItemEntities = new HashMap<UUID, ItemStack>();

    public SwordLifecycleListener(SwordTracker swordTracker, Plugin plugin) {
        this.swordTracker = swordTracker;
        this.plugin = plugin;
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item item = event.getEntity();
        this.handleSwordRemoval(item.getItemStack(), "despawned naturally");
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Item) {
            Item item = (Item)entity;
            if (event.getDamage() >= (double)item.getHealth() || event.getCause() == EntityDamageEvent.DamageCause.VOID || event.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                this.handleSwordRemoval(item.getItemStack(), "destroyed by " + event.getCause().name().toLowerCase());
            }
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        Item item;
        ItemStack itemStack;
        CelestialSword swordType;
        final Entity entity = event.getEntity();
        if (entity instanceof Item && (swordType = this.swordTracker.getSwordType(itemStack = (item = (Item)entity).getItemStack())) != null) {
            this.trackedItemEntities.put(entity.getUniqueId(), itemStack.clone());
            new BukkitRunnable(this){
                final /* synthetic */ SwordLifecycleListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!entity.isValid() || entity.isDead()) {
                        this.this$0.handleSwordRemoval(itemStack, "burned in fire");
                        this.this$0.trackedItemEntities.remove(entity.getUniqueId());
                    }
                }
            }.runTaskLater(this.plugin, 40L);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        String itemName;
        CelestialSword sword;
        Player player = event.getPlayer();
        Item droppedItem = event.getItemDrop();
        ItemStack itemStack = droppedItem.getItemStack();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = itemStack.getItemMeta().getDisplayName().substring(2))) != null && this.swordTracker.isSwordOwner(player, itemStack)) {
            this.swordTracker.untrackSword(player, sword);
            player.sendMessage("\u00a7cYou dropped your " + sword.getDisplayName() + "\u00a7c. Anyone can now pick it up.");
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        event.getLocation().getWorld().getNearbyEntities(event.getLocation(), 5.0, 5.0, 5.0).forEach(entity -> {
            Item item;
            ItemStack itemStack;
            if (entity instanceof Item && this.swordTracker.getSwordType(itemStack = (item = (Item)entity).getItemStack()) != null) {
                new BukkitRunnable(this, (Entity)entity, itemStack){
                    final /* synthetic */ Entity val$entity;
                    final /* synthetic */ ItemStack val$itemStack;
                    final /* synthetic */ SwordLifecycleListener this$0;
                    {
                        this.val$entity = entity;
                        this.val$itemStack = itemStack;
                        this.this$0 = this$0;
                    }

                    public void run() {
                        if (!this.val$entity.isValid() || this.val$entity.isDead()) {
                            this.this$0.handleSwordRemoval(this.val$itemStack, "destroyed by explosion");
                        }
                    }
                }.runTaskLater(this.plugin, 5L);
            }
        });
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        Item source = event.getEntity();
        Item target = event.getTarget();
        ItemStack sourceItem = source.getItemStack();
        ItemStack targetItem = target.getItemStack();
        CelestialSword sourceSword = this.swordTracker.getSwordType(sourceItem);
        CelestialSword targetSword = this.swordTracker.getSwordType(targetItem);
        if (sourceSword != null || targetSword != null) {
            event.setCancelled(true);
            this.plugin.getLogger().info("Prevented merging of Celestial Sword items to maintain tracking integrity");
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (final Entity entity : event.getChunk().getEntities()) {
            Item item;
            ItemStack itemStack;
            CelestialSword swordType;
            if (!(entity instanceof Item) || (swordType = this.swordTracker.getSwordType(itemStack = (item = (Item)entity).getItemStack())) == null) continue;
            this.trackedItemEntities.put(entity.getUniqueId(), itemStack.clone());
            new BukkitRunnable(this){
                final /* synthetic */ SwordLifecycleListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!entity.isValid() && this.this$0.trackedItemEntities.containsKey(entity.getUniqueId())) {
                        this.this$0.handleSwordRemoval(itemStack, "lost during chunk unload");
                        this.this$0.trackedItemEntities.remove(entity.getUniqueId());
                    }
                }
            }.runTaskLater(this.plugin, 200L);
        }
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        String itemName;
        CelestialSword sword;
        this.trackedItemEntities.remove(event.getItem().getUniqueId());
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem();
        ItemStack itemStack = item.getItemStack();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = itemStack.getItemMeta().getDisplayName().substring(2))) != null) {
            String cursorItemName;
            CelestialSword cursorSword;
            ItemStack cursorItem;
            boolean hasOtherCelestialSword = false;
            for (ItemStack invItem : player.getInventory().getContents()) {
                String invItemName;
                CelestialSword existingSword;
                if (invItem == null || !invItem.hasItemMeta() || !invItem.getItemMeta().hasDisplayName() || (existingSword = CelestialSword.getByName(invItemName = invItem.getItemMeta().getDisplayName().substring(2))) == null) continue;
                hasOtherCelestialSword = true;
                break;
            }
            if (!hasOtherCelestialSword && player.getOpenInventory() != null && (cursorItem = player.getItemOnCursor()) != null && cursorItem.hasItemMeta() && cursorItem.getItemMeta().hasDisplayName() && (cursorSword = CelestialSword.getByName(cursorItemName = cursorItem.getItemMeta().getDisplayName().substring(2))) != null) {
                hasOtherCelestialSword = true;
            }
            if (hasOtherCelestialSword) {
                event.setCancelled(true);
                player.sendMessage("\u00a7cYou cannot hold more than one Celestial Sword at a time.");
                return;
            }
            this.swordTracker.trackSword(player, itemStack, sword);
            player.sendMessage("\u00a7aYou have claimed the " + sword.getDisplayName() + "\u00a7a!");
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        ItemStack[] itemStackArray = event.getEntity();
        if (itemStackArray instanceof Player) {
            Player player = (Player)itemStackArray;
            for (ItemStack item : player.getInventory().getContents()) {
                String itemName;
                CelestialSword sword;
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || (sword = CelestialSword.getByName(itemName = item.getItemMeta().getDisplayName().substring(2))) == null || !this.swordTracker.isSwordOwner(player, item)) continue;
                player.sendMessage("\u00a7cYou dropped your " + sword.getDisplayName() + "\u00a7c. You can reclaim it if you find it!");
            }
        }
    }

    private void handleSwordRemoval(ItemStack item, String reason) {
        String itemName;
        CelestialSword sword;
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (sword = CelestialSword.getByName(itemName = item.getItemMeta().getDisplayName().substring(2))) != null) {
            boolean foundOwner = false;
            for (Player onlinePlayer : Bukkit.getServer().getOnlinePlayers()) {
                if (!this.swordTracker.isSwordOwner(onlinePlayer, item)) continue;
                this.swordTracker.untrackSword(onlinePlayer, sword);
                onlinePlayer.sendMessage("\u00a7cYour " + sword.getDisplayName() + " has been destroyed (" + reason + ").");
                foundOwner = true;
                break;
            }
            this.swordTracker.removeSwordCompletely(sword);
        }
    }
}

