/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.gui.SwordSelectionGUI;
import com.celestialswords.models.CelestialSword;
import com.celestialswords.tracking.SwordTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class SwordSelectionListener
implements Listener {
    private final Plugin plugin;
    private final SwordTracker swordTracker;
    private static final String SELECTION_COMMAND = "/cswords select";
    private static final Map<UUID, Item> pendingSelections = new HashMap<UUID, Item>();
    private static final Map<UUID, Long> messageTimestamps = new HashMap<UUID, Long>();
    private static final long MESSAGE_COOLDOWN_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Permission MULTI_SWORD_PERMISSION = new Permission("astral.multisword", "Allows players to hold more than one celestial sword", PermissionDefault.FALSE);

    public SwordSelectionListener(Plugin plugin, SwordTracker swordTracker) {
        this.plugin = plugin;
        this.swordTracker = swordTracker;
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        String itemName;
        CelestialSword groundSword;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem();
        ItemStack itemStack = item.getItemStack();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() && (groundSword = CelestialSword.getByName(itemName = itemStack.getItemMeta().getDisplayName().substring(2))) != null) {
            ItemStack currentSword = null;
            for (ItemStack invItem : player.getInventory().getContents()) {
                String invItemName;
                CelestialSword existingSword;
                if (invItem == null || !invItem.hasItemMeta() || !invItem.getItemMeta().hasDisplayName() || (existingSword = CelestialSword.getByName(invItemName = invItem.getItemMeta().getDisplayName().substring(2))) == null) continue;
                currentSword = invItem;
                break;
            }
            if (currentSword != null && !player.hasPermission(MULTI_SWORD_PERMISSION)) {
                event.setCancelled(true);
                pendingSelections.put(player.getUniqueId(), item);
                this.sendSelectionMessage(player, currentSword, itemStack);
            }
        }
    }

    @EventHandler
    public void onCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage();
        if (command.startsWith(SELECTION_COMMAND)) {
            event.setCancelled(true);
            Item groundItem = pendingSelections.get(player.getUniqueId());
            if (groundItem != null && !groundItem.isDead()) {
                ItemStack currentSword = null;
                for (ItemStack invItem : player.getInventory().getContents()) {
                    String invItemName;
                    CelestialSword existingSword;
                    if (invItem == null || !invItem.hasItemMeta() || !invItem.getItemMeta().hasDisplayName() || (existingSword = CelestialSword.getByName(invItemName = invItem.getItemMeta().getDisplayName().substring(2))) == null) continue;
                    currentSword = invItem;
                    break;
                }
                if (currentSword != null) {
                    SwordSelectionGUI.openSelectionGUI(player, currentSword, groundItem);
                } else {
                    player.sendMessage("\u00a7cYou no longer have a celestial sword in your inventory.");
                    pendingSelections.remove(player.getUniqueId());
                }
            } else {
                player.sendMessage("\u00a7cThere is no sword selection pending.");
                pendingSelections.remove(player.getUniqueId());
            }
        }
    }

    private void sendSelectionMessage(Player player, ItemStack currentSword, ItemStack groundSword) {
        long lastMessageTime;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (messageTimestamps.containsKey(playerId) && currentTime - (lastMessageTime = messageTimestamps.get(playerId).longValue()) < MESSAGE_COOLDOWN_MS) {
            return;
        }
        messageTimestamps.put(playerId, currentTime);
        String currentSwordName = currentSword.getItemMeta().getDisplayName();
        String groundSwordName = groundSword.getItemMeta().getDisplayName();
        Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"You found a ").color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)groundSwordName).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)" but you already have a ").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)currentSwordName).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)".").color((TextColor)NamedTextColor.GOLD));
        Component button = ((TextComponent)((TextComponent)Component.text((String)"[Choose Which Sword to Keep]").color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.runCommand((String)SELECTION_COMMAND));
        player.sendMessage(message);
        player.sendMessage(button);
        player.sendMessage(Component.text((String)"Click the button above to choose which sword to keep.").color((TextColor)NamedTextColor.GRAY));
    }

    public static void cleanupPendingSelections(Player player) {
        UUID playerId = player.getUniqueId();
        pendingSelections.remove(playerId);
        messageTimestamps.remove(playerId);
    }
}

