/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.listeners;

import com.celestialswords.utils.TriggerManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;

public class TriggerListener
implements Listener {
    private final Plugin plugin;

    public TriggerListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (TriggerManager.isListeningForTrigger(player)) {
            event.setCancelled(true);
            TriggerManager.setPlayerTrigger(player, "F");
            TriggerManager.setListeningForTrigger(player, false);
            player.sendMessage("\u00a7aTrigger set to: \u00a7bF key \u00a77(Swap Hands)");
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (TriggerManager.isListeningForTrigger(player)) {
            event.setCancelled(true);
            TriggerManager.setPlayerTrigger(player, "Q");
            TriggerManager.setListeningForTrigger(player, false);
            player.sendMessage("\u00a7aTrigger set to: \u00a7bQ key \u00a77(Drop Item)");
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!event.isSneaking()) {
            return;
        }
        if (TriggerManager.isListeningForTrigger(player)) {
            TriggerManager.setPlayerTrigger(player, "SHIFT");
            TriggerManager.setListeningForTrigger(player, false);
            player.sendMessage("\u00a7aTrigger set to: \u00a7bSHIFT key \u00a77(Sneak)");
        }
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        if (!event.isSprinting()) {
            return;
        }
        if (TriggerManager.isListeningForTrigger(player)) {
            TriggerManager.setPlayerTrigger(player, "CTRL");
            TriggerManager.setListeningForTrigger(player, false);
            player.sendMessage("\u00a7aTrigger set to: \u00a7bCTRL key \u00a77(Sprint)");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (TriggerManager.isListeningForTrigger(player)) {
            event.setCancelled(true);
            switch (event.getAction()) {
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    TriggerManager.setPlayerTrigger(player, "RIGHT_CLICK");
                    player.sendMessage("\u00a7aTrigger set to: \u00a7bRight Click");
                    break;
                }
                case LEFT_CLICK_AIR: 
                case LEFT_CLICK_BLOCK: {
                    TriggerManager.setPlayerTrigger(player, "LEFT_CLICK");
                    player.sendMessage("\u00a7aTrigger set to: \u00a7bLeft Click");
                    break;
                }
                default: {
                    return;
                }
            }
            TriggerManager.setListeningForTrigger(player, false);
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (TriggerManager.isListeningForTrigger(player)) {
            TriggerManager.setPlayerTrigger(player, "SCROLL");
            TriggerManager.setListeningForTrigger(player, false);
            player.sendMessage("\u00a7aTrigger set to: \u00a7bScroll Wheel \u00a77(Change Item)");
        }
    }
}

