/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.models;

import com.celestialswords.config.ConfigManager;
import com.celestialswords.models.SwordType;
import com.celestialswords.utils.GUIUtils;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public enum CelestialSword {
    SKYFALL_BLADE(0, "Skyfall Blade", SwordType.INITIATOR, new Material[]{Material.ELYTRA, Material.NETHER_STAR, Material.ELYTRA, Material.SHULKER_SHELL, Material.NETHERITE_INGOT, Material.SHULKER_SHELL, Material.END_CRYSTAL, Material.STICK, Material.END_CRYSTAL}),
    DRAGONS_WRATH(1, "Dragon's Wrath", SwordType.CONTROLLER, new Material[]{Material.DRAGON_HEAD, Material.DRAGON_BREATH, Material.DRAGON_HEAD, Material.DRAGON_BREATH, Material.NETHERITE_INGOT, Material.DRAGON_BREATH, Material.END_CRYSTAL, Material.STICK, Material.END_CRYSTAL}),
    SHADOWBANE(2, "Shadowbane", SwordType.CONTROLLER, new Material[]{Material.WITHER_SKELETON_SKULL, Material.ECHO_SHARD, Material.WITHER_SKELETON_SKULL, Material.WITHER_ROSE, Material.NETHERITE_INGOT, Material.WITHER_ROSE, Material.SCULK_CATALYST, Material.STICK, Material.SCULK_CATALYST}),
    THUNDERSTRIKE(3, "Thunderstrike", SwordType.DUELIST, new Material[]{Material.BEACON, Material.LIGHTNING_ROD, Material.BEACON, Material.HEART_OF_THE_SEA, Material.NETHERITE_INGOT, Material.HEART_OF_THE_SEA, Material.CONDUIT, Material.STICK, Material.CONDUIT}),
    VENOM_EDGE(4, "Venom Edge", SwordType.CONTROLLER, new Material[]{Material.FERMENTED_SPIDER_EYE, Material.WITHER_SKELETON_SKULL, Material.FERMENTED_SPIDER_EYE, Material.SPIDER_EYE, Material.NETHERITE_INGOT, Material.SPIDER_EYE, Material.POISONOUS_POTATO, Material.STICK, Material.POISONOUS_POTATO}),
    ECLIPSE_BLADE(5, "Eclipse Blade", SwordType.INITIATOR, new Material[]{Material.END_CRYSTAL, Material.DRAGON_HEAD, Material.END_CRYSTAL, Material.CHORUS_FLOWER, Material.NETHERITE_INGOT, Material.CHORUS_FLOWER, Material.PURPUR_BLOCK, Material.STICK, Material.PURPUR_BLOCK}),
    SOUL_REAVER(6, "Soul Reaver", SwordType.DUELIST, new Material[]{Material.TOTEM_OF_UNDYING, Material.NETHER_STAR, Material.TOTEM_OF_UNDYING, Material.SOUL_LANTERN, Material.NETHERITE_INGOT, Material.SOUL_LANTERN, Material.SOUL_SAND, Material.STICK, Material.SOUL_SAND}),
    PHOENIX_TALON(7, "Phoenix Talon", SwordType.DUELIST, new Material[]{Material.MAGMA_BLOCK, Material.FIRE_CHARGE, Material.MAGMA_BLOCK, Material.BLAZE_ROD, Material.NETHERITE_INGOT, Material.BLAZE_ROD, Material.ANCIENT_DEBRIS, Material.STICK, Material.ANCIENT_DEBRIS}),
    WARDENS_OATH(8, "Warden's Oath", SwordType.DUELIST, new Material[]{Material.SCULK_SENSOR, Material.SCULK_SHRIEKER, Material.SCULK_SENSOR, Material.ECHO_SHARD, Material.NETHERITE_INGOT, Material.ECHO_SHARD, Material.SCULK_CATALYST, Material.STICK, Material.SCULK_CATALYST}),
    WINDBLADE(9, "Windblade", SwordType.INITIATOR, new Material[]{Material.WIND_CHARGE, Material.HEAVY_CORE, Material.WIND_CHARGE, Material.TRIAL_KEY, Material.NETHERITE_INGOT, Material.TRIAL_KEY, Material.WIND_CHARGE, Material.BREEZE_ROD, Material.WIND_CHARGE}),
    POWER_HOUSE(10, "Power House", SwordType.DUELIST, new Material[]{Material.ANVIL, Material.NETHERITE_BLOCK, Material.ANVIL, Material.OBSIDIAN, Material.NETHERITE_INGOT, Material.OBSIDIAN, Material.IRON_BLOCK, Material.STICK, Material.IRON_BLOCK});

    private final int slot;
    private final String displayName;
    private final SwordType swordType;
    private final Material[] defaultRecipe;
    private Material[] configRecipe;
    private boolean craftingEnabled = true;
    private static ConfigManager configManager;

    private CelestialSword(int slot, String displayName, SwordType swordType, Material[] recipe) {
        this.slot = slot;
        this.displayName = displayName;
        this.swordType = swordType;
        this.defaultRecipe = recipe;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SwordType getSwordType() {
        return this.swordType;
    }

    public String getRecipeTitle() {
        return this.displayName + " Recipe";
    }

    public Material[] getRecipe() {
        return this.configRecipe != null ? this.configRecipe : this.defaultRecipe;
    }

    public void setConfigRecipe(Material[] recipe) {
        this.configRecipe = recipe;
    }

    public Material[] getDefaultRecipe() {
        return this.defaultRecipe;
    }

    public boolean isCraftingEnabled() {
        return this.craftingEnabled;
    }

    public void setCraftingEnabled(boolean enabled) {
        this.craftingEnabled = enabled;
    }

    public void fillRecipeInventory(Inventory gui) {
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            int slot = row * 9 + col;
            gui.setItem(slot, new ItemStack(this.getRecipe()[i]));
        }
        gui.setItem(14, GUIUtils.createSwordItem(this, true));
        gui.setItem(26, GUIUtils.createBackButton());
    }

    public static CelestialSword getByName(String name) {
        String normalizedInput = name.toLowerCase().replace("-", " ");
        for (CelestialSword sword : CelestialSword.values()) {
            if (!sword.getDisplayName().toLowerCase().equals(normalizedInput)) continue;
            return sword;
        }
        return null;
    }

    public static void setConfigManager(ConfigManager manager) {
        configManager = manager;
        if (configManager != null) {
            for (CelestialSword sword : CelestialSword.values()) {
                sword.setConfigRecipe(configManager.getSwordRecipe(sword));
            }
        }
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }
}

