/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.models;

import com.celestialswords.config.ConfigManager;
import com.celestialswords.models.CelestialSword;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SwordEnchantments {
    private static Map<CelestialSword, Map<Enchantment, Integer>> SWORD_ENCHANTMENTS = new HashMap<CelestialSword, Map<Enchantment, Integer>>();
    private static ConfigManager configManager;

    public static void applyEnchantments(CelestialSword sword, ItemStack item) {
        Map<Enchantment, Integer> enchants = configManager != null ? configManager.getSwordEnchantments(sword) : SWORD_ENCHANTMENTS.get((Object)sword);
        if (enchants != null && item.getItemMeta() != null) {
            ItemMeta meta = item.getItemMeta();
            enchants.forEach((enchantment, level) -> {
                if (enchantment != null) {
                    meta.addEnchant(enchantment, level.intValue(), true);
                }
            });
            item.setItemMeta(meta);
        }
    }

    public static void setConfigManager(ConfigManager manager) {
        configManager = manager;
    }
}

