/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.tracking;

import com.celestialswords.CelestialSwords;
import com.celestialswords.models.CelestialSword;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SwordTracker {
    private final CelestialSwords plugin;
    private final Map<UUID, Map<CelestialSword, UUID>> playerSwords;
    private final Map<CelestialSword, UUID> globalSwords;
    private final NamespacedKey swordIdKey;
    private static final Permission MULTI_SWORD_PERMISSION = new Permission("astral.multisword", "Allows players to hold more than one celestial sword", PermissionDefault.FALSE);

    public SwordTracker(CelestialSwords plugin) {
        this.plugin = plugin;
        this.playerSwords = new HashMap<UUID, Map<CelestialSword, UUID>>();
        this.globalSwords = new HashMap<CelestialSword, UUID>();
        this.swordIdKey = new NamespacedKey((Plugin)plugin, "sword_id");
        this.loadSwordData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCraftSword(Player player, CelestialSword swordType) {
        Map<UUID, Map<CelestialSword, UUID>> map = this.playerSwords;
        synchronized (map) {
            Map<CelestialSword, UUID> playerSwordMap;
            if (this.globalSwords.containsKey((Object)swordType)) {
                player.sendMessage("\u00a7cThe " + swordType.getDisplayName() + "\u00a7c already exists in the world! Each sword can only be crafted once on the server.");
                return false;
            }
            if (!player.hasPermission(MULTI_SWORD_PERMISSION)) {
                for (ItemStack item : player.getInventory().getContents()) {
                    String itemName;
                    if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || CelestialSword.getByName(itemName = item.getItemMeta().getDisplayName().substring(2)) == null) continue;
                    player.sendMessage("\u00a7cYou cannot craft another Celestial Sword while you have one in your inventory.");
                    return false;
                }
            }
            if ((playerSwordMap = this.playerSwords.get(player.getUniqueId())) != null && playerSwordMap.containsKey((Object)swordType)) {
                return false;
            }
            for (ItemStack item : player.getInventory().getContents()) {
                String itemName;
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !(itemName = item.getItemMeta().getDisplayName().substring(2)).equals(swordType.getDisplayName())) continue;
                if (this.isSwordOwner(player, item)) {
                    return false;
                }
                this.trackSword(player, item, swordType);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackSword(Player player, ItemStack swordItem, CelestialSword swordType) {
        Map<UUID, Map<CelestialSword, UUID>> map = this.playerSwords;
        synchronized (map) {
            UUID swordId = UUID.randomUUID();
            ItemMeta meta = swordItem.getItemMeta();
            if (meta != null) {
                PersistentDataContainer container = meta.getPersistentDataContainer();
                container.set(this.swordIdKey, PersistentDataType.STRING, (Object)swordId.toString());
                swordItem.setItemMeta(meta);
            }
            this.playerSwords.computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(swordType, swordId);
            this.globalSwords.put(swordType, swordId);
            this.saveSwordData();
        }
    }

    public void untrackSword(Player player, CelestialSword swordType) {
        Map<CelestialSword, UUID> playerSwordMap = this.playerSwords.get(player.getUniqueId());
        if (playerSwordMap != null) {
            playerSwordMap.remove((Object)swordType);
            if (playerSwordMap.isEmpty()) {
                this.playerSwords.remove(player.getUniqueId());
            }
            this.saveSwordData();
        }
    }

    public void removeSwordCompletely(CelestialSword swordType) {
        UUID removedId = this.globalSwords.remove((Object)swordType);
        for (Map<CelestialSword, UUID> playerSwordMap : this.playerSwords.values()) {
            playerSwordMap.remove((Object)swordType);
        }
        this.playerSwords.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        this.saveSwordData();
        if (removedId != null) {
            this.plugin.getLogger().info("Completely removed " + swordType.name() + " (ID: " + String.valueOf(removedId) + ") from tracking as it was destroyed.");
        } else {
            this.plugin.getLogger().info("Attempted to remove " + swordType.name() + " from tracking, but it wasn't found in global tracking.");
        }
    }

    public boolean isSwordOwner(Player player, ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String storedId = (String)container.get(this.swordIdKey, PersistentDataType.STRING);
        if (storedId == null) {
            return false;
        }
        Map<CelestialSword, UUID> playerSwordMap = this.playerSwords.get(player.getUniqueId());
        if (playerSwordMap == null) {
            return false;
        }
        return playerSwordMap.values().stream().map(UUID::toString).anyMatch(id -> id.equals(storedId));
    }

    public CelestialSword getSwordType(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return null;
        }
        String itemName = item.getItemMeta().getDisplayName().substring(2);
        return CelestialSword.getByName(itemName);
    }

    public UUID getSwordId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String storedId = (String)container.get(this.swordIdKey, PersistentDataType.STRING);
        if (storedId == null) {
            return null;
        }
        try {
            return UUID.fromString(storedId);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Found invalid UUID in sword: " + storedId);
            return null;
        }
    }

    private void saveSwordData() {
        File dataFile = new File(this.plugin.getDataFolder(), "sword_data.yml");
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<UUID, Map<CelestialSword, UUID>> entry : this.playerSwords.entrySet()) {
            String playerUUID = entry.getKey().toString();
            Map<CelestialSword, UUID> swordMap = entry.getValue();
            for (Map.Entry<CelestialSword, UUID> swordEntry : swordMap.entrySet()) {
                String path = "players." + playerUUID + "." + swordEntry.getKey().name();
                config.set(path, (Object)swordEntry.getValue().toString());
            }
        }
        for (Map.Entry<Object, Object> entry : this.globalSwords.entrySet()) {
            String path = "global." + ((CelestialSword)((Object)entry.getKey())).name();
            config.set(path, (Object)((UUID)entry.getValue()).toString());
        }
        try {
            if (!dataFile.getParentFile().exists()) {
                dataFile.getParentFile().mkdirs();
            }
            config.save(dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save sword data to " + String.valueOf(dataFile), e);
        }
    }

    private void loadSwordData() {
        File dataFile = new File(this.plugin.getDataFolder(), "sword_data.yml");
        if (!dataFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
        if (config.contains("players")) {
            for (String playerUUIDString : config.getConfigurationSection("players").getKeys(false)) {
                UUID playerUUID = UUID.fromString(playerUUIDString);
                HashMap<CelestialSword, UUID> swordMap = new HashMap<CelestialSword, UUID>();
                for (String swordName : config.getConfigurationSection("players." + playerUUIDString).getKeys(false)) {
                    try {
                        CelestialSword swordType = CelestialSword.valueOf(swordName);
                        String swordUUIDString = config.getString("players." + playerUUIDString + "." + swordName);
                        UUID swordUUID = UUID.fromString(swordUUIDString);
                        swordMap.put(swordType, swordUUID);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid sword type or UUID in config: " + swordName);
                    }
                }
                if (swordMap.isEmpty()) continue;
                this.playerSwords.put(playerUUID, swordMap);
            }
        }
        if (config.contains("global")) {
            for (String swordName : config.getConfigurationSection("global").getKeys(false)) {
                try {
                    CelestialSword swordType = CelestialSword.valueOf(swordName);
                    String swordUUIDString = config.getString("global." + swordName);
                    UUID swordUUID = UUID.fromString(swordUUIDString);
                    this.globalSwords.put(swordType, swordUUID);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid sword type or UUID in global config: " + swordName);
                }
            }
        }
        this.plugin.getLogger().info("Loaded sword data for " + this.playerSwords.size() + " players and " + this.globalSwords.size() + " global swords");
    }

    public void cleanup() {
        this.saveSwordData();
        this.playerSwords.clear();
        this.globalSwords.clear();
    }

    public boolean isSwordTracked(Player player, CelestialSword swordType) {
        Map<CelestialSword, UUID> playerSwordMap = this.playerSwords.get(player.getUniqueId());
        return playerSwordMap != null && playerSwordMap.containsKey((Object)swordType);
    }
}

