/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionBarManager {
    private static final Map<UUID, Integer> cooldownTasks = new HashMap<UUID, Integer>();

    public static void showCooldown(Player player, String swordName, long remainingCooldown) {
        int barLength = 20;
        int filledBars = (int)Math.ceil((double)remainingCooldown / 20.0 * (double)barLength);
        StringBuilder cooldownBar = new StringBuilder("\u00a7c");
        for (int i = 0; i < barLength; ++i) {
            cooldownBar.append(i < filledBars ? "\u2588" : "\u00a77\u2588");
        }
        String message = String.format("\u00a76%s \u00a77[%s\u00a77] \u00a7c%ds", swordName, cooldownBar.toString(), remainingCooldown);
        player.sendActionBar((Component)Component.text((String)message));
    }

    public static void startPersistentCooldown(Plugin plugin, Player player, String swordName, long endTime) {
        UUID playerId = player.getUniqueId();
        ActionBarManager.stopPersistentCooldown(player);
        int taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, () -> {
            long remainingCooldown = (endTime - System.currentTimeMillis()) / 1000L;
            if (remainingCooldown <= 0L) {
                ActionBarManager.stopPersistentCooldown(player);
                player.sendActionBar((Component)Component.text((String)String.format("\u00a7a%s is ready!", swordName)));
            } else {
                ActionBarManager.showCooldown(player, swordName, remainingCooldown);
            }
        }, 0L, 1L);
        cooldownTasks.put(playerId, taskId);
    }

    public static void stopPersistentCooldown(Player player) {
        UUID playerId = player.getUniqueId();
        if (cooldownTasks.containsKey(playerId)) {
            Bukkit.getScheduler().cancelTask(cooldownTasks.get(playerId).intValue());
            cooldownTasks.remove(playerId);
        }
    }

    public static void sendMessage(Player player, String message) {
        player.sendActionBar((Component)Component.text((String)message));
    }
}

