/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.utils;

import com.celestialswords.models.CelestialSword;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnnouncementManager {
    private static final String[] CRAFT_TEMPLATES = new String[]{"{player} has forged the {sword_name}, unleashing its power upon the realm!", "The legendary {sword_name} has been crafted by {player}!", "A new {sword_name} enters the world, forged by the hands of {player}!", "The skies tremble as {player} creates the mighty {sword_name}!", "Behold! {player} has crafted the {sword_name}!"};
    private static final String[] ANONYMOUS_CRAFT_TEMPLATES = new String[]{"An anonymous has forged the {sword_name}, unleashing its power upon the realm!", "The legendary {sword_name} has been crafted by an unknown warrior!", "A new {sword_name} enters the world, forged by mysterious hands!", "The skies tremble as a hidden craftsman creates the mighty {sword_name}!", "Behold! The {sword_name} has been crafted by someone in the shadows!"};
    private static boolean announcementsEnabled = true;
    private static boolean announcePlayerNames = true;

    public static void announceSwordCrafting(Player player, CelestialSword sword) {
        if (!announcementsEnabled) {
            return;
        }
        String template = announcePlayerNames ? CRAFT_TEMPLATES[(int)(Math.random() * (double)CRAFT_TEMPLATES.length)] : ANONYMOUS_CRAFT_TEMPLATES[(int)(Math.random() * (double)ANONYMOUS_CRAFT_TEMPLATES.length)];
        String message = template.replace("{player}", player.getName()).replace("{sword_name}", sword.getDisplayName());
        TextComponent.Builder announcementBuilder = Component.text();
        int swordNameIndex = message.indexOf(sword.getDisplayName());
        if (swordNameIndex != -1) {
            announcementBuilder.append((Component)Component.text((String)message.substring(0, swordNameIndex), (TextColor)NamedTextColor.GOLD));
            TextComponent swordComponent = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(sword.getDisplayName()).color(AnnouncementManager.getColorForSwordType(sword))).decoration(TextDecoration.BOLD, true)).build();
            TextComponent.Builder hoverTextBuilder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)sword.getDisplayName(), (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.newline())).append((Component)Component.text((String)("Type: " + sword.getSwordType().name()), (TextColor)NamedTextColor.GRAY));
            if (announcePlayerNames) {
                ((TextComponent.Builder)hoverTextBuilder.append((Component)Component.newline())).append((Component)Component.text((String)("Crafted by: " + player.getName()), (TextColor)NamedTextColor.AQUA));
            }
            TextComponent hoverText = (TextComponent)hoverTextBuilder.build();
            swordComponent = (TextComponent)swordComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
            announcementBuilder.append((Component)swordComponent);
            announcementBuilder.append((Component)Component.text((String)message.substring(swordNameIndex + sword.getDisplayName().length()), (TextColor)NamedTextColor.GOLD));
        } else {
            announcementBuilder.append((Component)Component.text((String)message, (TextColor)NamedTextColor.GOLD));
        }
        TextComponent announcement = (TextComponent)announcementBuilder.build();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.sendMessage((Component)announcement);
        }
    }

    private static TextColor getColorForSwordType(CelestialSword sword) {
        switch (sword.getSwordType()) {
            case INITIATOR: {
                return NamedTextColor.AQUA;
            }
            case CONTROLLER: {
                return NamedTextColor.DARK_PURPLE;
            }
            case DUELIST: {
                return NamedTextColor.RED;
            }
            case SENTINEL: {
                return NamedTextColor.GREEN;
            }
        }
        return NamedTextColor.YELLOW;
    }

    public static boolean setSwordAnnouncementsEnabled(boolean enabled) {
        announcementsEnabled = enabled;
        return announcementsEnabled;
    }

    public static boolean areSwordAnnouncementsEnabled() {
        return announcementsEnabled;
    }

    public static boolean setAnnouncePlayerNames(boolean enabled) {
        announcePlayerNames = enabled;
        return announcePlayerNames;
    }

    public static boolean isAnnouncePlayerNamesEnabled() {
        return announcePlayerNames;
    }
}

