/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.utils;

import com.celestialswords.models.CelestialSword;
import com.celestialswords.models.SwordEnchantments;
import com.celestialswords.models.SwordModelData;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIUtils {
    public static ItemStack createSwordItem(CelestialSword sword, boolean includeRecipeHint) {
        ItemStack item = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76" + sword.getDisplayName());
            meta.setCustomModelData(Integer.valueOf(SwordModelData.getModelData(sword)));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77A legendary Astral Sword");
            lore.add("\u00a76Type: \u00a7e" + sword.getSwordType().getDisplayName());
            lore.add("\u00a77" + sword.getSwordType().getDescription());
            if (sword == CelestialSword.VENOM_EDGE) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Activate ability");
                lore.add("\u00a72Poison Effect: \u00a77Applies poison for 10 seconds");
                lore.add("Slowness Effect: \u00a77Applies Slowness for 3 seconds");
                lore.add("\u00a7cCooldown: \u00a7720 seconds");
            } else if (sword == CelestialSword.SKYFALL_BLADE) {
                lore.add("\u00a7bSpecial Effect: \u00a77Immune to fall damage");
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77");
                lore.add("\u00a771. When used on the ground: Launches you upward and creates");
                lore.add("\u00a77   an explosion where you land.");
                lore.add("\u00a77");
                lore.add("\u00a772. When used while jumping: Activates flight mode. Upon landing,");
                lore.add("\u00a77   triggers an explosion with damage based on falling velocity.");
                lore.add("\u00a7cCooldown: \u00a7730 seconds");
            } else if (sword == CelestialSword.DRAGONS_WRATH) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Unleash dragon's breath");
                lore.add("\u00a77Creates an area of dragon breath that damages");
                lore.add("\u00a77and applies wither effect to enemies");
                lore.add("\u00a7cCooldown: \u00a7720 seconds");
            } else if (sword == CelestialSword.SHADOWBANE) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Activate ability");
                lore.add("\u00a78Weakness Effect: \u00a77Applies weakness for 15 seconds");
                lore.add("\u00a78Blindness Effect: \u00a77Applies Blindness for 3 seconds");
                lore.add("\u00a7cCooldown: \u00a7720 seconds");
            } else if (sword == CelestialSword.THUNDERSTRIKE) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Toggle lightning strike mode");
                lore.add("\u00a77When active:");
                lore.add("\u00a77- 45% chance to strike lightning");
                lore.add("\u00a77- +1.5\u2764 damage on critical hits");
                lore.add("\u00a77- +0.5\u2764 damage on normal hits");
            } else if (sword == CelestialSword.ECLIPSE_BLADE) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Activate ability");
                lore.add("\u00a7dStealth Effect: \u00a77Grants 90 seconds of invisibility");
                lore.add("\u00a75Blindness Effect: \u00a77Blinds nearby enemies (non-trusted) for 3 seconds");
                lore.add("\u00a7cCooldown: \u00a7720 seconds");
            } else if (sword == CelestialSword.PHOENIX_TALON) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Launch a powerful fireball");
                lore.add("\u00a77Creates a massive explosion on impact");
                lore.add("\u00a77Grants permanent fire resistance");
                lore.add("\u00a7cCooldown: \u00a7720 seconds");
            } else if (sword == CelestialSword.WARDENS_OATH) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Launch a devastating sonic boom");
                lore.add("\u00a77Deals massive damage and knockback to enemies");
                lore.add("\u00a77in its path");
                lore.add("\u00a7cCooldown: \u00a7725 seconds");
            } else if (sword == CelestialSword.SOUL_REAVER) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Activate ability");
                lore.add("\u00a75Passive Ability: \u00a77Absorb enemy souls on hit");
                lore.add("\u00a77- Heal 0.5\u2764 on normal hits");
                lore.add("\u00a77- Heal 1.5\u2764 on critical hits");
            } else if (sword == CelestialSword.WINDBLADE) {
                lore.add("\u00a7bPassive Ability: \u00a77Grants Speed II while holding");
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Dash forward and upward");
                lore.add("\u00a77Creates wind particles during dash");
                lore.add("\u00a7cCooldown: \u00a775 seconds");
            } else if (sword == CelestialSword.POWER_HOUSE) {
                lore.add("\u00a7eAbility (Press 'Off Hand Key'): \u00a77Ground Strike");
                lore.add("\u00a77Launches enemies into the air and deals damage");
                lore.add("\u00a77within a 15-block radius.");
                lore.add("\u00a7cCooldown: \u00a7730 seconds");
            }
            if (includeRecipeHint) {
                lore.add("\u00a77Click to view recipe");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            SwordEnchantments.applyEnchantments(sword, item);
        }
        return item;
    }

    public static ItemStack createBackButton() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7c\u2190 Back to Swords");
            item.setItemMeta(meta);
        }
        return item;
    }
}

