/*
 * Decompiled with CFR 0.152.
 */
package com.celestialswords.utils;

import com.celestialswords.models.CelestialSword;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ParticleEffectManager {
    private final Plugin plugin;

    public ParticleEffectManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void playSwordActivationEffect(Player player, CelestialSword sword) {
        switch (sword) {
            case ECLIPSE_BLADE: {
                this.playEclipseBladeEffect(player);
                break;
            }
            case PHOENIX_TALON: {
                this.playPhoenixTalonEffect(player);
                break;
            }
            case SKYFALL_BLADE: {
                this.playSkyfallEffect(player);
                break;
            }
            case DRAGONS_WRATH: {
                this.playDragonWrathEffect(player);
                break;
            }
            case SHADOWBANE: {
                this.playShadowbaneEffect(player);
                break;
            }
            case THUNDERSTRIKE: {
                this.playThunderstrikeEffect(player);
                break;
            }
            case VENOM_EDGE: {
                this.playVenomEdgeEffect(player);
                break;
            }
            case SOUL_REAVER: {
                this.playSoulReaverEffect(player);
                break;
            }
            case WARDENS_OATH: {
                this.playWardenOathEffect(player);
                break;
            }
            case WINDBLADE: {
                this.playWindbladeEffect(player);
                break;
            }
            case POWER_HOUSE: {
                this.playPowerHouseEffect(player);
            }
        }
    }

    public void playEclipseBladeEffect(final Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.SOUL, location, 30, 0.5, 1.0, 0.5, 0.05);
        player.getWorld().spawnParticle(Particle.SMOKE, location, 20, 0.5, 1.0, 0.5, 0.05);
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = 40;

            public void run() {
                if (this.ticks >= 40 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location currentLoc = player.getLocation();
                double radius = 1.0;
                double y = 0.0;
                for (int i = 0; i < 2; ++i) {
                    double angle = (double)this.ticks * 0.5 + Math.PI * (double)i;
                    double x = radius * Math.cos(angle);
                    double z = radius * Math.sin(angle);
                    Location particleLoc = currentLoc.clone().add(x, y, z);
                    player.getWorld().spawnParticle(Particle.SOUL, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                    player.getWorld().spawnParticle(Particle.SMOKE, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                    y += 0.1;
                    if (!(y > 2.0)) continue;
                    y = 0.0;
                }
                ++this.ticks;
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void playPhoenixTalonEffect(final Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.FLAME, location, 40, 0.5, 1.0, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.LAVA, location, 15, 0.5, 1.0, 0.5, 0.1);
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = 40;

            public void run() {
                if (this.ticks >= 40 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location currentLoc = player.getLocation();
                for (int i = 0; i < 3; ++i) {
                    double offsetX = (Math.random() - 0.5) * 1.5;
                    double offsetZ = (Math.random() - 0.5) * 1.5;
                    Location particleLoc = currentLoc.clone().add(offsetX, 0.1, offsetZ);
                    player.getWorld().spawnParticle(Particle.FLAME, particleLoc, 1, 0.1, 0.1, 0.1, 0.05);
                    if (!(Math.random() < 0.3)) continue;
                    player.getWorld().spawnParticle(Particle.LAVA, particleLoc, 1, 0.1, 0.1, 0.1, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void playSkyfallEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.CLOUD, location, 50, 0.5, 0.5, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.SNOWFLAKE, location, 20, 0.5, 0.5, 0.5, 0.05);
    }

    public void playDragonWrathEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.DRAGON_BREATH, location, 100, 1.0, 1.0, 1.0, 0.1);
        player.getWorld().spawnParticle(Particle.END_ROD, location, 20, 1.0, 1.0, 1.0, 0.1);
    }

    public void playShadowbaneEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.SMOKE, location, 30, 0.5, 1.0, 0.5, 0.05);
        player.getWorld().spawnParticle(Particle.SQUID_INK, location, 20, 0.5, 1.0, 0.5, 0.05);
    }

    public void playThunderstrikeEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, location, 40, 0.5, 1.0, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.WAX_ON, location, 20, 0.5, 1.0, 0.5, 0.1);
    }

    public void playVenomEdgeEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.SQUID_INK, location, 30, 0.5, 1.0, 0.5, 0.1);
        player.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, location, 20, 0.5, 1.0, 0.5, 0.0);
    }

    public void playSoulReaverEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.SOUL, location, 30, 0.5, 1.0, 0.5, 0.05);
        player.getWorld().spawnParticle(Particle.SCULK_SOUL, location, 20, 0.5, 1.0, 0.5, 0.0);
    }

    public void playWardenOathEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.SONIC_BOOM, location, 5, 0.2, 0.2, 0.2, 0.0);
        player.getWorld().spawnParticle(Particle.SCULK_CHARGE, location, 20, 0.5, 1.0, 0.5, 0.0);
    }

    public void playWindbladeEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.CLOUD, location, 30, 0.2, 0.0, 0.2, 0.05);
        player.getWorld().spawnParticle(Particle.FIREWORK, location, 10, 0.2, 0.0, 0.2, 0.05);
    }

    public void playPowerHouseEffect(Player player) {
        Location location = player.getLocation();
        player.getWorld().spawnParticle(Particle.EXPLOSION, location, 10, 0.5, 0.5, 0.5, 0.0);
        player.getWorld().spawnParticle(Particle.FLAME, location, 20, 0.5, 0.5, 0.5, 0.1);
    }

    public void createSpiralEffect(final Location location, final Particle particle, final double radius, final double height, final int density) {
        new BukkitRunnable(this){
            double y = 0.0;
            int ticks = 0;
            final int maxTicks = 40;

            public void run() {
                if (this.ticks >= 40) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    double angle = this.y * 2.0 + Math.PI * 2 * (double)i / (double)density;
                    double x = radius * Math.cos(angle);
                    double z = radius * Math.sin(angle);
                    Location particleLoc = location.clone().add(x, this.y, z);
                    location.getWorld().spawnParticle(particle, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.y += height / 20.0;
                if (this.y > height) {
                    this.y = 0.0;
                }
                ++this.ticks;
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void createCircleEffect(Location location, Particle particle, double radius, int density) {
        for (int i = 0; i < density; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)density;
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            Location particleLoc = location.clone().add(x, 0.0, z);
            location.getWorld().spawnParticle(particle, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

