/*
 * Decompiled with CFR 0.152.
 */
package net.ticench.mod;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.ticench.mod.Config;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class EventHandler {
    static boolean postinit = false;
    public static HashMap<Enchantment, ModifierId> ench2mod = new HashMap();

    public static int costOfLevel(Enchantment enchantment, int level) {
        int rarity_price = 0;
        switch (enchantment.m_44699_()) {
            case COMMON: {
                rarity_price = 1;
                break;
            }
            case UNCOMMON: {
                rarity_price = 2;
                break;
            }
            case RARE: {
                rarity_price = 4;
                break;
            }
            case VERY_RARE: {
                rarity_price = 8;
            }
        }
        return rarity_price * level;
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!postinit) {
            Config.postInit();
        }
        if ((event.getLeft().m_41720_() instanceof ModifiableItem || event.getLeft().m_41720_() instanceof ModifiableArmorItem || event.getLeft().m_41720_() instanceof ModifiableLauncherItem) && event.getRight().m_41720_() == Items.f_42690_) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)event.getRight());
            HashMap<Enchantment, Integer> enchantmentsToBeApplied = new HashMap<Enchantment, Integer>();
            ItemStack leftToModify = event.getLeft().m_41777_();
            ToolStack toolStack = ToolStack.from((ItemStack)leftToModify);
            int tcost = 0;
            for (Object enchantment : enchantments.keySet()) {
                if (ench2mod.containsKey(enchantment)) {
                    int curLevel = toolStack.getModifierLevel(ench2mod.get(enchantment));
                    int newLevel = (Integer)enchantments.get(enchantment);
                    if (newLevel > curLevel) {
                        if (curLevel > 0) {
                            toolStack.removeModifier(ench2mod.get(enchantment), curLevel);
                        }
                        toolStack.addModifier(ench2mod.get(enchantment), newLevel);
                        tcost += EventHandler.costOfLevel((Enchantment)enchantment, newLevel);
                        continue;
                    }
                    if (newLevel == curLevel && newLevel + 1 <= Config.COMMON.enchlvls.getOrDefault(enchantment, enchantment.m_6586_())) {
                        if (curLevel > 0) {
                            toolStack.removeModifier(ench2mod.get(enchantment), curLevel);
                        }
                        toolStack.addModifier(ench2mod.get(enchantment), newLevel + 1);
                        tcost += EventHandler.costOfLevel((Enchantment)enchantment, newLevel + 1);
                        continue;
                    }
                    event.setCanceled(true);
                    return;
                }
                enchantmentsToBeApplied.put((Enchantment)enchantment, Math.min((Integer)enchantments.get(enchantment), Config.COMMON.enchlvls.getOrDefault(enchantment, enchantment.m_6586_())));
                tcost += EventHandler.costOfLevel((Enchantment)enchantment, Math.min((Integer)enchantments.get(enchantment), Config.COMMON.enchlvls.getOrDefault(enchantment, enchantment.m_6586_())));
            }
            toolStack.rebuildStats();
            Map leftEnchants = EnchantmentHelper.m_44831_((ItemStack)event.getLeft());
            for (Enchantment enchantment : leftEnchants.keySet()) {
                if ((Integer)leftEnchants.get(enchantment) > enchantmentsToBeApplied.getOrDefault(enchantment, 0)) {
                    enchantmentsToBeApplied.put(enchantment, Math.min((Integer)enchantments.get(enchantment), (Integer)leftEnchants.get(enchantment)));
                    continue;
                }
                if (!Objects.equals(leftEnchants.get(enchantment), enchantmentsToBeApplied.getOrDefault(enchantment, 0))) continue;
                if (Config.COMMON.enchlvls.getOrDefault(enchantment, enchantment.m_6586_()) < (Integer)leftEnchants.get(enchantment) + 1) {
                    event.setCanceled(true);
                    return;
                }
                enchantmentsToBeApplied.put(enchantment, (Integer)leftEnchants.get(enchantment) + 1);
                tcost += 3;
            }
            int cost = (event.getName() != null ? 1 : 0) + tcost;
            EnchantmentHelper.m_44865_(enchantmentsToBeApplied, (ItemStack)leftToModify);
            leftToModify.m_41742_(cost);
            event.setOutput(leftToModify);
            event.setCost(cost);
            event.setResult(Event.Result.ALLOW);
        }
    }

    static {
        ench2mod.put(Enchantments.f_44986_, ModifierIds.reinforced);
        ench2mod.put(Enchantments.f_44965_, ModifierIds.protection);
        ench2mod.put(Enchantments.f_44966_, ModifierIds.fireProtection);
        ench2mod.put(Enchantments.f_44968_, ModifierIds.blastProtection);
        ench2mod.put(Enchantments.f_44969_, ModifierIds.projectileProtection);
        ench2mod.put(Enchantments.f_44967_, ModifierIds.featherFalling);
        ench2mod.put(Enchantments.f_44970_, ModifierIds.respiration);
        ench2mod.put(Enchantments.f_44971_, ModifierIds.aquaAffinity);
        ench2mod.put(Enchantments.f_44972_, ModifierIds.thorns);
        ench2mod.put(Enchantments.f_44973_, ModifierIds.depthStrider);
        ench2mod.put(Enchantments.f_44974_, ModifierIds.frostWalker);
        ench2mod.put(Enchantments.f_44976_, TinkerModifiers.soulspeed.getId());
        ench2mod.put(Enchantments.f_220304_, ModifierIds.swiftSneak);
        ench2mod.put(Enchantments.f_44977_, ModifierIds.sharpness);
        ench2mod.put(Enchantments.f_44978_, ModifierIds.smite);
        ench2mod.put(Enchantments.f_44979_, ModifierIds.baneOfSssss);
        ench2mod.put(Enchantments.f_44980_, TinkerModifiers.knockback.getId());
        ench2mod.put(Enchantments.f_44981_, ModifierIds.fiery);
        ench2mod.put(Enchantments.f_44982_, ModifierIds.luck);
        ench2mod.put(Enchantments.f_44983_, TinkerModifiers.sweeping.getId());
        ench2mod.put(Enchantments.f_44956_, ModifierIds.antiaquatic);
        ench2mod.put(Enchantments.f_44984_, ModifierIds.haste);
        ench2mod.put(Enchantments.f_44985_, TinkerModifiers.silky.getId());
        ench2mod.put(Enchantments.f_44987_, ModifierIds.luck);
        ench2mod.put(Enchantments.f_44988_, ModifierIds.power);
        ench2mod.put(Enchantments.f_44989_, TinkerModifiers.punch.getId());
        ench2mod.put(Enchantments.f_44990_, ModifierIds.fiery);
        ench2mod.put(Enchantments.f_44952_, ModifierIds.crystalshot);
        ench2mod.put(Enchantments.f_44959_, TinkerModifiers.multishot.getId());
        ench2mod.put(Enchantments.f_44960_, ModifierIds.quickCharge);
        ench2mod.put(Enchantments.f_44961_, TinkerModifiers.impaling.getId());
    }
}

