/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.plugin.Plugin;

public class ItemCooldowns
implements Listener {
    private final SMPEssentialsV1 plugin;
    private Map<Material, Double> itemCooldowns = new HashMap<Material, Double>();
    private File cooldownsFile;
    private FileConfiguration cooldownsConfig;

    public ItemCooldowns(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
        this.loadCooldownsFile();
        this.loadCooldowns();
    }

    private void loadCooldownsFile() {
        this.cooldownsFile = new File(this.plugin.getDataFolder(), "itemcooldowns.yml");
        if (!this.cooldownsFile.exists()) {
            try {
                this.cooldownsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create itemcooldowns.yml!");
                e.printStackTrace();
            }
        }
        this.cooldownsConfig = YamlConfiguration.loadConfiguration((File)this.cooldownsFile);
    }

    private void loadCooldowns() {
        if (this.cooldownsConfig.contains("cooldowns")) {
            this.itemCooldowns.clear();
            for (String key : this.cooldownsConfig.getConfigurationSection("cooldowns").getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)key.toUpperCase());
                    double cooldown = this.cooldownsConfig.getDouble("cooldowns." + key);
                    this.itemCooldowns.put(material, cooldown);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material in itemcooldowns.yml: " + key);
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.itemCooldowns.size() + " item cooldown(s)");
    }

    private void saveCooldowns() {
        if (this.cooldownsConfig.getConfigurationSection("cooldowns") == null) {
            this.cooldownsConfig.createSection("cooldowns");
        }
        for (Map.Entry<Material, Double> entry : this.itemCooldowns.entrySet()) {
            this.cooldownsConfig.set("cooldowns." + entry.getKey().name().toLowerCase(), (Object)entry.getValue());
        }
        try {
            this.cooldownsConfig.save(this.cooldownsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save itemcooldowns.yml!");
            e.printStackTrace();
        }
    }

    private void applyCooldown(Player player, Material item) {
        if (this.itemCooldowns.containsKey(item)) {
            double cooldownSeconds = this.itemCooldowns.get(item);
            int cooldownTicks = (int)Math.round(cooldownSeconds * 20.0);
            player.setCooldown(item, cooldownTicks);
        }
    }

    @EventHandler
    public void onItemUse(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            Material item = player.getInventory().getItemInMainHand().getType();
            if (this.isEdibleOrDrinkable(item) || item == Material.BOW || item == Material.TRIDENT || item == Material.CROSSBOW || item == Material.SHIELD) {
                return;
            }
            if (this.itemCooldowns.containsKey(item)) {
                if (player.hasCooldown(item)) {
                    event.setCancelled(true);
                    return;
                }
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applyCooldown(player, item), 1L);
            }
        }
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Material item = event.getItem().getType();
        this.applyCooldown(player, item);
    }

    private boolean isEdibleOrDrinkable(Material item) {
        return item.isEdible() || item == Material.POTION || item == Material.MILK_BUCKET || item == Material.HONEY_BOTTLE;
    }

    @EventHandler
    public void onBowShoot(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Material shotItem = event.getBow().getType();
            if (shotItem == Material.BOW || shotItem == Material.CROSSBOW) {
                this.applyCooldown(player, shotItem);
            }
        }
    }

    @EventHandler
    public void onTridentThrow(ProjectileLaunchEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            Player player = (Player)event.getEntity().getShooter();
            if (event.getEntity() instanceof Trident) {
                this.applyCooldown(player, Material.TRIDENT);
            }
        }
    }

    @EventHandler
    public void onRiptideUse(PlayerRiptideEvent event) {
        Player player = event.getPlayer();
        this.applyCooldown(player, Material.TRIDENT);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        Player player;
        Material item;
        if (event.getDamager() instanceof Player && this.isWeaponOrTool(item = (player = (Player)event.getDamager()).getInventory().getItemInMainHand().getType()) && this.itemCooldowns.containsKey(item)) {
            if (player.hasCooldown(item)) {
                event.setCancelled(true);
            } else {
                this.applyCooldown(player, item);
            }
        }
    }

    private boolean isWeaponOrTool(Material item) {
        return item.name().endsWith("_SWORD") || item.name().endsWith("_AXE") || item.name().endsWith("_PICKAXE") || item.name().endsWith("_SHOVEL") || item.name().endsWith("_HOE") || item.name().contains("MACE") || item == Material.TRIDENT;
    }

    @EventHandler
    public void onShieldBlock(EntityDamageByEntityEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).isBlocking() && (player.getInventory().getItemInOffHand().getType() == Material.SHIELD || player.getInventory().getItemInMainHand().getType() == Material.SHIELD)) {
            this.applyCooldown(player, Material.SHIELD);
        }
    }

    @EventHandler
    public void onTotemUse(EntityResurrectEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.hasCooldown(Material.TOTEM_OF_UNDYING)) {
                event.setCancelled(true);
                return;
            }
            this.applyCooldown(player, Material.TOTEM_OF_UNDYING);
        }
    }

    public boolean handleCommand(CommandSender sender, Command command, String[] args) {
        if (command.getName().equalsIgnoreCase("setcooldown") || command.getName().equalsIgnoreCase("itemcooldowns")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            if (args.length != 2) {
                sender.sendMessage("\u00a7eUsage: /setcooldown <item> <seconds>");
                return true;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                double cooldown = Double.parseDouble(args[1]);
                if (cooldown <= 0.0) {
                    sender.sendMessage("\u00a7cCooldown must be greater than 0!");
                    return true;
                }
                this.itemCooldowns.put(material, cooldown);
                this.cooldownsConfig.set("cooldowns." + material.name().toLowerCase(), (Object)cooldown);
                this.saveCooldowns();
                sender.sendMessage("\u00a7aSet cooldown for " + material.name() + " to " + cooldown + " seconds.");
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid cooldown value.");
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cInvalid item name.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("resetcooldown")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage("\u00a7eUsage: /resetcooldown <item> OR /resetcooldown all");
                return true;
            }
            if (args[0].equalsIgnoreCase("all")) {
                this.itemCooldowns.clear();
                this.cooldownsConfig.set("cooldowns", null);
                this.saveCooldowns();
                sender.sendMessage("\u00a7aAll cooldown settings have been wiped!");
                return true;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                if (this.itemCooldowns.containsKey(material)) {
                    this.itemCooldowns.remove(material);
                    this.cooldownsConfig.set("cooldowns." + material.name().toLowerCase(), null);
                    this.saveCooldowns();
                    sender.sendMessage("\u00a7aCooldown for " + material.name() + " has been reset.");
                } else {
                    sender.sendMessage("\u00a7eNo cooldown found for " + material.name() + ".");
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cInvalid item name.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("checkcooldown")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage("\u00a7eUsage: /checkcooldown <item>");
                return true;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                if (this.itemCooldowns.containsKey(material)) {
                    sender.sendMessage("\u00a7aCooldown for " + material.name() + " is " + String.valueOf(this.itemCooldowns.get(material)) + " seconds.");
                } else {
                    sender.sendMessage("\u00a7eNo cooldown set for " + material.name() + ".");
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage("\u00a7cInvalid item name.");
            }
            return true;
        }
        return false;
    }
}

