/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.ItemCooldowns;
import me.poggercity.sMPEssentialsV1.features.BanNetheriteFeature;
import me.poggercity.sMPEssentialsV1.features.BanPotionsFeature;
import me.poggercity.sMPEssentialsV1.features.BanShieldsFeature;
import me.poggercity.sMPEssentialsV1.features.BanTier2PotionsFeature;
import me.poggercity.sMPEssentialsV1.features.DisableEnderPearlsFeature;
import me.poggercity.sMPEssentialsV1.features.EnchantmentLimitFeature;
import me.poggercity.sMPEssentialsV1.features.ProtectionLimitFeature;
import me.poggercity.sMPEssentialsV1.features.SharpnessLimitFeature;
import me.poggercity.sMPEssentialsV1.features.XaeroMinimapDisableFeature;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class SMPEssentialsV1
extends JavaPlugin
implements Listener {
    private List<Feature> features;
    private ProtectionLimitFeature protectionLimitFeature;
    private SharpnessLimitFeature sharpnessLimitFeature;
    private BanShieldsFeature banShieldsFeature;
    private XaeroMinimapDisableFeature xaeroMinimapDisableFeature;
    private BanPotionsFeature banPotionsFeature;
    private BanTier2PotionsFeature banTier2PotionsFeature;
    private BanNetheriteFeature banNetheriteFeature;
    private DisableEnderPearlsFeature disableEnderPearlsFeature;
    private EnchantmentLimitFeature enchantmentLimitFeature;
    private boolean netherBlocked = false;
    private boolean endBlocked = false;
    private boolean pvpDisabled = false;
    private File itemLimitsFile;
    private FileConfiguration itemLimitsConfig;
    private Map<Material, Integer> itemLimits = new HashMap<Material, Integer>();
    private BukkitTask itemLimitCheckTask;
    private ItemCooldowns itemCooldowns;
    private boolean gracePeriodActive = false;
    private BossBar gracePeriodBar;
    private BukkitTask gracePeriodTask;
    private int gracePeriodTimeLeft = 0;

    public void onEnable() {
        this.saveDefaultConfig();
        this.features = new ArrayList<Feature>();
        this.registerFeatures();
        this.loadAllFeatures();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.netherBlocked = this.getConfig().getBoolean("dimension-blocking.nether-blocked", false);
        this.endBlocked = this.getConfig().getBoolean("dimension-blocking.end-blocked", false);
        this.pvpDisabled = this.getConfig().getBoolean("pvp.disabled", false);
        this.loadItemLimits();
        this.itemLimitCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkAllPlayersItemLimits, 40L, 40L);
        this.itemCooldowns = new ItemCooldowns(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.itemCooldowns, (Plugin)this);
        this.gracePeriodBar = Bukkit.createBossBar((String)"Grace Period", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.gracePeriodBar.setVisible(false);
        this.getLogger().info("SMPEssentials has been enabled!");
        this.getLogger().info("Loaded " + this.features.size() + " feature(s)");
    }

    public void onDisable() {
        for (Feature feature : this.features) {
            feature.disable();
        }
        if (this.itemLimitCheckTask != null) {
            this.itemLimitCheckTask.cancel();
        }
        if (this.gracePeriodTask != null) {
            this.gracePeriodTask.cancel();
        }
        if (this.gracePeriodBar != null) {
            this.gracePeriodBar.removeAll();
        }
        this.getLogger().info("SMPEssentials has been disabled!");
    }

    private void registerFeatures() {
        this.protectionLimitFeature = new ProtectionLimitFeature(this);
        this.features.add(this.protectionLimitFeature);
        this.sharpnessLimitFeature = new SharpnessLimitFeature(this);
        this.features.add(this.sharpnessLimitFeature);
        this.banShieldsFeature = new BanShieldsFeature(this);
        this.features.add(this.banShieldsFeature);
        this.xaeroMinimapDisableFeature = new XaeroMinimapDisableFeature(this);
        this.features.add(this.xaeroMinimapDisableFeature);
        this.banPotionsFeature = new BanPotionsFeature(this);
        this.features.add(this.banPotionsFeature);
        this.banTier2PotionsFeature = new BanTier2PotionsFeature(this);
        this.features.add(this.banTier2PotionsFeature);
        this.banNetheriteFeature = new BanNetheriteFeature(this);
        this.features.add(this.banNetheriteFeature);
        this.disableEnderPearlsFeature = new DisableEnderPearlsFeature(this);
        this.features.add(this.disableEnderPearlsFeature);
        this.enchantmentLimitFeature = new EnchantmentLimitFeature(this);
        this.features.add(this.enchantmentLimitFeature);
    }

    private void loadAllFeatures() {
        for (Feature feature : this.features) {
            feature.load();
            this.getLogger().info("Loaded feature: " + feature.getName());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("smpessentials")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("smpessentials.reload")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                    return true;
                }
                this.reloadConfig();
                this.netherBlocked = this.getConfig().getBoolean("dimension-blocking.nether-blocked", false);
                this.endBlocked = this.getConfig().getBoolean("dimension-blocking.end-blocked", false);
                this.pvpDisabled = this.getConfig().getBoolean("pvp.disabled", false);
                for (Feature feature : this.features) {
                    feature.reload();
                }
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Plugin configuration reloaded."));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== SMPEssentials ===");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/smpessentials reload - Reload the configuration");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Features loaded: " + this.features.size());
            sender.sendMessage("");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Active Features:");
            for (Feature feature : this.features) {
                sender.sendMessage(String.valueOf(ChatColor.WHITE) + "  - " + feature.getName() + ": " + (feature.isEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("netherblock")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /netherblock <true|false>");
                return true;
            }
            if (args[0].equalsIgnoreCase("true")) {
                this.netherBlocked = true;
                this.getConfig().set("dimension-blocking.nether-blocked", (Object)true);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cThe Nether has been &lblocked&c!"));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getWorld().getEnvironment() != World.Environment.NETHER) continue;
                    player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You have been teleported to spawn because the Nether was blocked!");
                }
            } else if (args[0].equalsIgnoreCase("false")) {
                this.netherBlocked = false;
                this.getConfig().set("dimension-blocking.nether-blocked", (Object)false);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aThe Nether has been &lunblocked&a!"));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /netherblock <true|false>");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("endblock")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /endblock <true|false>");
                return true;
            }
            if (args[0].equalsIgnoreCase("true")) {
                this.endBlocked = true;
                this.getConfig().set("dimension-blocking.end-blocked", (Object)true);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&5The End has been &lblocked&5!"));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getWorld().getEnvironment() != World.Environment.THE_END) continue;
                    player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You have been teleported to spawn because the End was blocked!");
                }
            } else if (args[0].equalsIgnoreCase("false")) {
                this.endBlocked = false;
                this.getConfig().set("dimension-blocking.end-blocked", (Object)false);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&dThe End has been &lunblocked&d!"));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /endblock <true|false>");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("pvp")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /pvp <enable|disable>");
                return true;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                this.pvpDisabled = true;
                this.getConfig().set("pvp.disabled", (Object)true);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cPvP has been &ldisabled&c!"));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "PvP has been disabled!");
                }
            } else if (args[0].equalsIgnoreCase("enable")) {
                this.pvpDisabled = false;
                this.getConfig().set("pvp.disabled", (Object)false);
                this.saveConfig();
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aPvP has been &lenabled&a!"));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "PvP has been enabled!");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /pvp <enable|disable>");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("setitemlimit")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length != 2) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /setitemlimit <item> <limit>");
                return true;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                int limit = Integer.parseInt(args[1]);
                if (limit < 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Limit must be 0 or greater!");
                    return true;
                }
                if (limit == 0) {
                    this.itemLimits.remove(material);
                    this.itemLimitsConfig.set("limits." + material.name(), null);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed item limit for " + material.name());
                } else {
                    this.itemLimits.put(material, limit);
                    this.itemLimitsConfig.set("limits." + material.name(), (Object)limit);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set item limit for " + material.name() + " to " + limit);
                }
                this.saveItemLimits();
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material or number!");
            }
            return true;
        }
        if (this.itemCooldowns.handleCommand(sender, command, args)) {
            return true;
        }
        if (command.getName().equalsIgnoreCase("graceperiod")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /graceperiod <seconds>");
                return true;
            }
            try {
                int seconds = Integer.parseInt(args[0]);
                if (seconds <= 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Seconds must be greater than 0!");
                    return true;
                }
                this.startGracePeriod(seconds);
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&aGrace period started for &l" + seconds + "&a seconds!")));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.sendTitle(String.valueOf(ChatColor.GREEN) + "Grace Period Started", String.valueOf(ChatColor.YELLOW) + "PvP is disabled for " + seconds + " seconds", 10, 70, 20);
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number!");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("endgraceperiod")) {
            if (!sender.hasPermission("smpessentials.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (!this.gracePeriodActive) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No grace period is active!");
                return true;
            }
            this.endGracePeriod();
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aGrace period ended manually!"));
            return true;
        }
        return false;
    }

    private void startGracePeriod(int seconds) {
        if (this.gracePeriodActive) {
            this.endGracePeriod();
        }
        this.gracePeriodActive = true;
        this.gracePeriodTimeLeft = seconds;
        this.gracePeriodBar.setVisible(true);
        this.gracePeriodBar.setProgress(1.0);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.gracePeriodBar.addPlayer(player);
        }
        int totalSeconds = seconds;
        this.gracePeriodTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            --this.gracePeriodTimeLeft;
            double progress = (double)this.gracePeriodTimeLeft / (double)totalSeconds;
            this.gracePeriodBar.setProgress(Math.max(0.0, progress));
            this.gracePeriodBar.setTitle("Grace Period: " + this.gracePeriodTimeLeft + "s");
            if (this.gracePeriodTimeLeft <= 0) {
                this.endGracePeriod();
            }
        }, 20L, 20L);
    }

    private void endGracePeriod() {
        this.gracePeriodActive = false;
        if (this.gracePeriodTask != null) {
            this.gracePeriodTask.cancel();
            this.gracePeriodTask = null;
        }
        this.gracePeriodBar.setVisible(false);
        this.gracePeriodBar.removeAll();
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(String.valueOf(ChatColor.RED) + "Grace Period is now over", String.valueOf(ChatColor.YELLOW) + "PvP is now enabled!", 10, 70, 20);
        }
    }

    @EventHandler
    public void onPlayerJoinGracePeriod(PlayerJoinEvent event) {
        if (this.gracePeriodActive && this.gracePeriodBar != null) {
            this.gracePeriodBar.addPlayer(event.getPlayer());
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (this.gracePeriodActive && event.getEntity() instanceof Player) {
            event.setCancelled(true);
        }
    }

    private void loadItemLimits() {
        this.itemLimitsFile = new File(this.getDataFolder(), "itemlimits.yml");
        if (!this.itemLimitsFile.exists()) {
            try {
                this.itemLimitsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create itemlimits.yml!");
                e.printStackTrace();
            }
        }
        this.itemLimitsConfig = YamlConfiguration.loadConfiguration((File)this.itemLimitsFile);
        this.itemLimits.clear();
        if (this.itemLimitsConfig.contains("limits")) {
            for (String key : this.itemLimitsConfig.getConfigurationSection("limits").getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)key);
                    int limit = this.itemLimitsConfig.getInt("limits." + key);
                    this.itemLimits.put(material, limit);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid material in itemlimits.yml: " + key);
                }
            }
        }
        this.getLogger().info("Loaded " + this.itemLimits.size() + " item limit(s)");
    }

    private void saveItemLimits() {
        try {
            this.itemLimitsConfig.save(this.itemLimitsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save itemlimits.yml!");
            e.printStackTrace();
        }
    }

    private void checkAllPlayersItemLimits() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerItemLimits(player);
        }
    }

    private void checkPlayerItemLimits(Player player) {
        for (Map.Entry<Material, Integer> entry : this.itemLimits.entrySet()) {
            Material material = entry.getKey();
            int limit = entry.getValue();
            int totalCount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != material) continue;
                totalCount += item.getAmount();
            }
            if (totalCount <= limit) continue;
            int toRemove = totalCount - limit;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != material || toRemove <= 0) continue;
                int removeFromStack = Math.min(toRemove, item.getAmount());
                item.setAmount(item.getAmount() - removeFromStack);
                ItemStack drop = new ItemStack(material, removeFromStack);
                player.getWorld().dropItemNaturally(player.getLocation(), drop);
                toRemove -= removeFromStack;
            }
        }
    }

    @EventHandler
    public void onPlayerJoinItemLimit(PlayerJoinEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.checkPlayerItemLimits(event.getPlayer()), 20L);
    }

    @EventHandler
    public void onInventoryClickItemLimit(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.checkPlayerItemLimits(player), 1L);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (!this.pvpDisabled && !this.gracePeriodActive) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            event.setCancelled(true);
            Player damager = (Player)event.getDamager();
            if (!this.gracePeriodActive) {
                damager.sendMessage(String.valueOf(ChatColor.RED) + "PvP is currently disabled!");
            }
        }
    }

    @EventHandler
    public void onPortalUse(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        World.Environment from = player.getWorld().getEnvironment();
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL && this.netherBlocked && from != World.Environment.NETHER) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "The Nether is currently blocked!");
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && this.endBlocked) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "The End is currently blocked!");
        }
    }
}

