/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.plugin.Plugin;

public class BanNetheriteFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private boolean enabled;

    public BanNetheriteFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.plugin.getLogger().info("Ban Netherite: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Netherite: Disabled");
        }
    }

    @Override
    public void reload() {
        this.loadConfig();
        if (this.enabled) {
            this.plugin.getLogger().info("Ban Netherite reloaded: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Netherite reloaded: Disabled");
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public String getName() {
        return "Ban Netherite";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("features.BAN_NETHERITE", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareSmithing(PrepareSmithingEvent event) {
        Material m;
        if (!this.enabled) {
            return;
        }
        SmithingInventory inv = event.getInventory();
        ItemStack template = inv.getItem(0);
        ItemStack base = inv.getItem(1);
        ItemStack addition = inv.getItem(2);
        if (template != null && base != null && addition != null && template.getType() == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE && (this.isDiamondArmor(m = base.getType()) || this.isDiamondTool(m) || this.isDiamondSword(m))) {
            event.setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSmith(SmithItemEvent event) {
        Material m;
        if (!this.enabled) {
            return;
        }
        SmithingInventory inv = event.getInventory();
        ItemStack template = inv.getItem(0);
        ItemStack base = inv.getItem(1);
        ItemStack addition = inv.getItem(2);
        if (template != null && base != null && addition != null && template.getType() == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE && (this.isDiamondArmor(m = base.getType()) || this.isDiamondTool(m) || this.isDiamondSword(m))) {
            event.setCancelled(true);
        }
    }

    private boolean isDiamondArmor(Material m) {
        return m == Material.DIAMOND_HELMET || m == Material.DIAMOND_CHESTPLATE || m == Material.DIAMOND_LEGGINGS || m == Material.DIAMOND_BOOTS;
    }

    private boolean isDiamondSword(Material m) {
        return m == Material.DIAMOND_SWORD;
    }

    private boolean isDiamondTool(Material m) {
        return m == Material.DIAMOND_PICKAXE || m == Material.DIAMOND_AXE || m == Material.DIAMOND_SHOVEL || m == Material.DIAMOND_HOE;
    }
}

