/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BanPotionsFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private boolean enabled;

    public BanPotionsFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.plugin.getLogger().info("Ban Potions: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Potions: Disabled");
        }
    }

    @Override
    public void reload() {
        this.loadConfig();
        if (this.enabled) {
            this.plugin.getLogger().info("Ban Potions reloaded: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Potions reloaded: Disabled");
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public String getName() {
        return "Ban Potions";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("features.BAN_POTIONS", false);
    }

    private boolean isPotion(Material material) {
        return material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && this.isPotion(item.getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDrinkPotion(PlayerItemConsumeEvent event) {
        if (!this.enabled) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && this.isPotion(item.getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPotionThrow(ProjectileLaunchEvent event) {
        ThrownPotion potion;
        if (!this.enabled) {
            return;
        }
        if (event.getEntity() instanceof ThrownPotion && (potion = (ThrownPotion)event.getEntity()).getShooter() instanceof Player) {
            Player player = (Player)potion.getShooter();
            ItemStack potionItem = potion.getItem();
            event.setCancelled(true);
            player.getInventory().addItem(new ItemStack[]{potionItem});
        }
    }
}

